/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.util.SortableId;
import com.google.common.base.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FixedSlotItemAssignmentProblem
implements SortableId {
    private final IWorkSlot workSlot;
    private final IProcessingItem item;

    protected FixedSlotItemAssignmentProblem(IWorkSlot workSlot, IProcessingItem item) {
        this.workSlot = workSlot;
        this.item = item;
    }

    public IWorkSlot getWorkSlot() {
        return this.workSlot;
    }

    @Override
    public String getId() {
        return this.item.getId();
    }

    @Override
    public String getSortKey() {
        return this.item.getSortKey();
    }

    public IProcessingItem getItem() {
        return this.item;
    }

    public static Optional<FixedSlotItemAssignmentProblem> tryCreateForItem(IProcessingItem item) {
        Optional<Integer> slotIndex = item.getAssignmentRestriction().getWorkSlotIndex();
        if (!slotIndex.isPresent()) {
            return Optional.absent();
        }
        IWorkSlot slot = item.getAssignmentRestriction().getResourcePools().iterator().next().getResourceGroup().getWorkSlotWithIndex((Integer)slotIndex.get());
        return Optional.of((Object)new FixedSlotItemAssignmentProblem(slot, item));
    }
}

