/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.BaseProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.DecisionVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.FixedSlotItemAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.IFixedSlotsAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.IResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivity;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivitySet;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IStageTask;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IUnstructuredItem;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmSortableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MaximizeWorkProblem
extends BaseProblem {
    private static final Log LOGGER = Log.with(MaximizeWorkProblem.class);

    MaximizeWorkProblem(Set<DecisionVariable> decisionVariables, List<IProcessingItem> items, List<IWorkResource> resources, IWorkSlot workSlot, Map<String, ? extends PositivePrimitivesMap<IResourceType>> demands) {
        super(decisionVariables, items, workSlot, resources, demands);
    }

    @Override
    int getVariableCount() {
        return this.allWorkDecisionVariables.size();
    }

    @Override
    Set<DecisionVariable> getLimitedVariablesForResource(final String resourceId) {
        return Sets.filter((Set)this.allWorkDecisionVariables, (Predicate)new Predicate<DecisionVariable>(){

            public boolean apply(DecisionVariable decisionVariable) {
                return resourceId.equals(decisionVariable.getResource().getId());
            }
        });
    }

    boolean isCompleteSolution(float[] solution) {
        LOGGER.debug("check if solution complete: %s", Arrays.toString(solution));
        float sum = 0.0f;
        for (IProcessingItem item : this.items) {
            sum += item.getWorkDemand().getDemand();
        }
        if (Math.abs(sum - RmUtils.sum(solution)) < 0.01f) {
            LOGGER.debug("solution is complete", new Object[0]);
            return true;
        }
        LOGGER.debug("solution is not complete", new Object[0]);
        return false;
    }

    static MaximizeWorkProblem create(IWorkSlot workSlot, IFixedSlotsAssignmentProblem slotsAssignmentProblem) {
        LOGGER.debug("create max work problem for slot %s and problem: %s", workSlot, slotsAssignmentProblem);
        Builder builder = new Builder(workSlot);
        for (FixedSlotItemAssignmentProblem problem : RmSortableUtils.sort(slotsAssignmentProblem.getAssignmentProblemsForSlot(workSlot))) {
            builder.tryAddProcessingItem(problem.getItem());
        }
        return builder.build();
    }

    Map<String, ? extends PositivePrimitivesMap<IResourceType>> getDemands() {
        return this.demands;
    }

    static class Builder {
        private final IWorkSlot workSlot;
        private Set<IWorkResource> allResources = Sets.newHashSet();
        private List<IProcessingItem> items = Lists.newArrayList();
        private Set<DecisionVariable> decisionVariables = Sets.newHashSet();
        private Map<String, MutablePositivePrimitivesMap<IResourceType>> demands = Maps.newHashMap();

        Builder(IWorkSlot workSlot) {
            this.workSlot = workSlot;
        }

        Builder tryAddProcessingItem(IProcessingItem item) {
            Optional<IResourcePool> pool = RmIdentifiableUtils.tryFindElementWithId(this.workSlot.getGroupId(), item.getAssignmentRestriction().getResourcePools());
            if (!pool.isPresent()) {
                LOGGER.warn("resource pool not available - ignoring item %s", item.getId());
                return this;
            }
            this.items.add(item);
            this.allResources.addAll(item.getAssignmentRestriction().getResources());
            if (item instanceof IActivitySet) {
                IActivitySet activitySet = (IActivitySet)item;
                this.addStructuredDecisionVariables(activitySet, ((IResourcePool)pool.get()).getResourceGroup());
                for (IActivity activity : activitySet.getActivities()) {
                    this.addStructuredDemands(activitySet, activity);
                }
            } else if (item instanceof IUnstructuredItem) {
                this.addUnstructuredDecisionVariables((IUnstructuredItem)item, ((IResourcePool)pool.get()).getResourceGroup());
                this.demands.put(item.getId(), RmCollectionUtils.newMutablePositiveMap(item.getWorkDemand().getPositiveTypeAmounts()));
            } else {
                LOGGER.warn("unknown implementation of processing item: %s", item.getId());
            }
            return this;
        }

        private void addStructuredDemands(IActivitySet activitySet, IActivity activity) {
            this.addDemand(activitySet.getId(), activity.getPositiveTypeAmounts());
            for (IStageTask stageTask : activity.getStageTasks()) {
                this.addDemand(stageTask.getId(), stageTask.getPositiveTypeAmounts());
            }
        }

        private void addDemand(String id, PositivePrimitivesMap<IResourceType> positiveTypeAmounts) {
            if (!positiveTypeAmounts.isEmpty()) {
                if (!this.demands.containsKey(id)) {
                    this.demands.put(id, RmCollectionUtils.newMutablePositiveMap(positiveTypeAmounts));
                } else {
                    this.demands.get(id).add(positiveTypeAmounts);
                }
            }
        }

        private void addStructuredDecisionVariables(IActivitySet item, IResourceGroup resourceGroup) {
            for (IActivity activity : item.getActivities()) {
                for (IStageTask stageTask : activity.getStageTasks()) {
                    for (IWorkResource resource : Builder.getSortedAvailableResources(stageTask.getAssignmentRestriction(), resourceGroup)) {
                        for (IResourceType resourceType : RmSortableUtils.sort(Sets.intersection(resource.getResourceTypes(), stageTask.getPositiveTypeAmounts().keySet()))) {
                            DecisionVariable decisionVariable = new DecisionVariable(resource, resourceType, item, stageTask.getId(), this.decisionVariables.size(), resourceGroup, activity.getProcessingStage());
                            this.decisionVariables.add(decisionVariable);
                            LOGGER.debug("add decision variable for stage task: %s", decisionVariable);
                        }
                    }
                }
                for (IWorkResource resource : Builder.getSortedAvailableResources(item.getAssignmentRestriction(), resourceGroup)) {
                    for (IResourceType resourceType : RmSortableUtils.sort(Sets.intersection(resource.getResourceTypes(), activity.getPositiveTypeAmounts().keySet()))) {
                        DecisionVariable decisionVariable = new DecisionVariable(resource, resourceType, item, item.getId(), this.decisionVariables.size(), resourceGroup, activity.getProcessingStage());
                        this.decisionVariables.add(decisionVariable);
                        LOGGER.debug("add decision variable activity: %s", decisionVariable);
                    }
                }
            }
        }

        private void addUnstructuredDecisionVariables(IUnstructuredItem item, IResourceGroup resourceGroup) {
            for (IWorkResource resource : Builder.getSortedAvailableResources(item.getAssignmentRestriction(), resourceGroup)) {
                for (IProcessingStage stage : item.getSpecifiedStages()) {
                    for (IResourceType resourceType : this.getSortedAvailableResourceTypes(item, stage, resource)) {
                        DecisionVariable decisionVariable = new DecisionVariable(resource, resourceType, item, item.getId(), this.decisionVariables.size(), resourceGroup, stage);
                        this.decisionVariables.add(decisionVariable);
                        LOGGER.debug("add decision variable: %s", decisionVariable);
                    }
                }
            }
        }

        private List<IResourceType> getSortedAvailableResourceTypes(IProcessingItem item, IProcessingStage stage, IWorkResource resource) {
            IProcessingStageWorkPackage stagePackage = (IProcessingStageWorkPackage)item.getWorkPackageForStage(stage).get();
            return RmSortableUtils.sort(Sets.intersection(stagePackage.getResourceTypes(), resource.getResourceTypes()));
        }

        private static List<IWorkResource> getSortedAvailableResources(AssignmentRestriction restriction, IResourceGroup resourceGroup) {
            return RmSortableUtils.sort(Sets.intersection(restriction.getResources(), resourceGroup.getResources()));
        }

        MaximizeWorkProblem build() {
            return new MaximizeWorkProblem(this.decisionVariables, this.items, RmSortableUtils.sort(this.allResources), this.workSlot, this.demands);
        }
    }
}

