/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.FixedSlotWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.FixedSlotsAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo.TransformedGroupAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo.WarningDetector;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.ActivitySchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.ActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IEpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivity;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivitySet;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;

class TransformedActivitySetSchedule {
    private static final Log LOGGER = Log.with(TransformedActivitySetSchedule.class);
    private static final WarningDetector WARNING_DETECTOR = new WarningDetector();

    TransformedActivitySetSchedule() {
    }

    static IActivitySetSchedule create(IActivitySet item, FixedSlotsAssignmentSolution solution, IEpisodeSchedule scheduleToIntegrate) {
        LOGGER.debug("create activity set schedule for %s in episode schedule %s", item.getId(), scheduleToIntegrate.getId());
        HashSet activitySchedules = Sets.newHashSet();
        for (IActivity activity : item.getActivities()) {
            LOGGER.debug("create schedule for activity %s", activity.getId());
            Set<FixedSlotWorkAssignment> assignments = solution.getWorkAssignmentsForItemAndStage(item.getId(), RmIdentifiableUtils.getIds(activity.getStageTasks()), activity.getProcessingStage().getId());
            LOGGER.debug("found %d assignments: %s", assignments.size(), Iterables.toString(assignments));
            TransformedGroupAssignment groupAssignment = TransformedGroupAssignment.create(assignments, solution.getWorkSlot(item.getId()), scheduleToIntegrate.getEpisode());
            activitySchedules.add(new ActivitySchedule(activity, groupAssignment, solution.getWorkSlot(item.getId()).getStart()));
        }
        Set<IScheduleWarning> warnings = TransformedActivitySetSchedule.getScheduleWarnings(item, solution, scheduleToIntegrate);
        LOGGER.debug("add %d warnings: %s", warnings.size(), Iterables.toString(warnings));
        return ActivitySetSchedule.createSchedule(item, solution.getResourceGroup(item.getId()), activitySchedules, warnings, solution.getWorkSlot(item.getId()).getStart());
    }

    private static Set<IScheduleWarning> getScheduleWarnings(IActivitySet item, FixedSlotsAssignmentSolution solution, IEpisodeSchedule scheduleToIntegrate) {
        Set<IScheduleWarning> warnings = WARNING_DETECTOR.getWarnings(item, solution, scheduleToIntegrate);
        warnings.addAll(solution.getWarningsForItem(item.getId()));
        return warnings;
    }
}

