/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.SubsetSelectionPool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentTransformationResult;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.GroupAssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.IResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.SubTaskConflictViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.AssignmentResource;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StageTaskAwareAssignmentRestriction
implements AssignmentRestriction {
    private static final Log LOGGER = Log.with(StageTaskAwareAssignmentRestriction.class);
    private final AssignmentRestriction parentAssignmentRestriction;
    private final Map<String, AssignmentRestriction> stageTaskAssignments;

    public StageTaskAwareAssignmentRestriction(AssignmentRestriction parentAssignmentRestriction, Map<String, AssignmentRestriction> stageTaskAssignments) {
        this.parentAssignmentRestriction = parentAssignmentRestriction;
        this.stageTaskAssignments = stageTaskAssignments;
    }

    @Override
    public Set<IMutableResourcePool> filterMutableResourcePools(Set<IMutableResourceGroup> mutableResourceGroups) {
        Set<IResourcePool> resourcePools = this.parentAssignmentRestriction.getResourcePools();
        HashSet mergedPools = Sets.newHashSet();
        for (IResourcePool parentPool : resourcePools) {
            HashSet resources = Sets.newHashSet(parentPool.getResources());
            for (AssignmentRestriction stageRestriction : this.stageTaskAssignments.values()) {
                Optional<IResourcePool> stagePool = RmIdentifiableUtils.tryFindElementWithId(parentPool.getId(), stageRestriction.getResourcePools());
                if (stagePool.isPresent()) {
                    resources.addAll(((IResourcePool)stagePool.get()).getResources());
                }
                IMutableResourceGroup mutableGroup = (IMutableResourceGroup)RmIdentifiableUtils.tryFindElementWithId(parentPool.getId(), mutableResourceGroups).get();
                SubsetSelectionPool mutableResourcePool = new SubsetSelectionPool(mutableGroup, RmIdentifiableUtils.getElementsWithIds(RmIdentifiableUtils.getIds(resources), mutableGroup.getMutableResources()));
                mergedPools.add(mutableResourcePool);
            }
        }
        return mergedPools;
    }

    @Override
    public Set<IResourcePool> getResourcePools() {
        return this.parentAssignmentRestriction.getResourcePools();
    }

    @Override
    public Optional<Integer> getWorkSlotIndex() {
        return this.parentAssignmentRestriction.getWorkSlotIndex();
    }

    @Override
    public Set<String> getResourceGroupIds() {
        return this.parentAssignmentRestriction.getResourceGroupIds();
    }

    @Override
    public Optional<AssignmentRestriction> getStageTaskResourceRestriction(String stageTaskId) {
        return Optional.fromNullable((Object)this.stageTaskAssignments.get(stageTaskId));
    }

    @Override
    public Set<AssignmentResource> filterResources(Set<AssignmentResource> skillRelevantResources) {
        return this.parentAssignmentRestriction.filterResources(skillRelevantResources);
    }

    @Override
    public Set<IWorkResource> getResources() {
        HashSet allResources = Sets.newHashSet(this.parentAssignmentRestriction.getResources());
        for (AssignmentRestriction assignmentRestriction : this.stageTaskAssignments.values()) {
            allResources.addAll(assignmentRestriction.getResources());
        }
        return allResources;
    }

    private static Optional<AssignmentRestriction> create(AssignmentRestriction parentRestriction, Map<String, AssignmentRestriction> subTaskResults) {
        if (subTaskResults.isEmpty()) {
            LOGGER.debug("no sub-task restrictions", new Object[0]);
            return Optional.of((Object)parentRestriction);
        }
        Set<String> subTaskGroupIntersection = StageTaskAwareAssignmentRestriction.getCommonGroups(subTaskResults.values());
        if (subTaskGroupIntersection.isEmpty()) {
            LOGGER.debug("assignment conflict between sub-tasks", new Object[0]);
            return Optional.absent();
        }
        Sets.SetView availableGroups = Sets.intersection(parentRestriction.getResourceGroupIds(), subTaskGroupIntersection);
        if (availableGroups.isEmpty()) {
            LOGGER.debug("assignment conflict between sub-task(s) and parent issue", new Object[0]);
            return Optional.absent();
        }
        if (parentRestriction.getResourceGroupIds().size() <= subTaskGroupIntersection.size()) {
            LOGGER.debug("sub-tasks do not restrict parent issue", new Object[0]);
            return Optional.of((Object)new StageTaskAwareAssignmentRestriction(parentRestriction, StageTaskAwareAssignmentRestriction.wrap((Set<String>)availableGroups, subTaskResults)));
        }
        LOGGER.debug("subtask(s) restrict parent issue", new Object[0]);
        GroupAssignmentRestriction restricted = new GroupAssignmentRestriction(parentRestriction, (Set<String>)availableGroups);
        return Optional.of((Object)new StageTaskAwareAssignmentRestriction(restricted, StageTaskAwareAssignmentRestriction.wrap((Set<String>)availableGroups, subTaskResults)));
    }

    private static Map<String, AssignmentRestriction> wrap(Set<String> availableGroups, Map<String, AssignmentRestriction> subTaskResults) {
        HashMap wrapped = Maps.newHashMap();
        for (Map.Entry<String, AssignmentRestriction> entry : subTaskResults.entrySet()) {
            wrapped.put(entry.getKey(), new GroupAssignmentRestriction(entry.getValue(), availableGroups));
        }
        return wrapped;
    }

    private static Set<String> getCommonGroups(Collection<AssignmentRestriction> values) {
        HashSet commonGroups = Sets.newHashSet(values.iterator().next().getResourceGroupIds());
        for (AssignmentRestriction value : values) {
            commonGroups = Sets.intersection((Set)commonGroups, value.getResourceGroupIds());
        }
        return commonGroups;
    }

    public static Builder builder(String id, AssignmentTransformationResult parentRestriction) {
        return new Builder(id, parentRestriction);
    }

    public static class Builder {
        private final String id;
        private final AssignmentTransformationResult parentRestriction;
        private final Map<String, AssignmentTransformationResult> subTaskResults = Maps.newHashMap();

        Builder(String id, AssignmentTransformationResult parentRestriction) {
            this.id = id;
            this.parentRestriction = parentRestriction;
        }

        public AssignmentTransformationResult build() {
            LOGGER.debug("build assignment for issue: %s", this.id);
            Set<IScheduleViolation> violations = this.mergeViolations();
            if (!violations.isEmpty()) {
                LOGGER.debug("transformation result contains %d violations", violations.size());
                return new AssignmentTransformationResult(violations, this.mergeWarnings());
            }
            Optional merged = StageTaskAwareAssignmentRestriction.create((AssignmentRestriction)this.parentRestriction.getAssignmentRestriction().get(), this.getSubTaskRestrictions());
            if (!merged.isPresent()) {
                LOGGER.debug("violations when merging sub-task assignments", new Object[0]);
                return new AssignmentTransformationResult(Sets.newHashSet((Object[])new IScheduleViolation[]{new SubTaskConflictViolation(this.id)}), this.mergeWarnings());
            }
            LOGGER.debug("created assignment transformation for issue: %s", this.id);
            return new AssignmentTransformationResult((AssignmentRestriction)merged.get(), this.mergeWarnings(), this.isAnyResourceOrAssigneeRestricted(), this.isAnyTeamRestricted());
        }

        private Map<String, AssignmentRestriction> getSubTaskRestrictions() {
            HashMap restrictions = Maps.newHashMap();
            for (Map.Entry<String, AssignmentTransformationResult> entry : this.subTaskResults.entrySet()) {
                restrictions.put(entry.getKey(), entry.getValue().getAssignmentRestriction().get());
            }
            return restrictions;
        }

        private boolean isAnyTeamRestricted() {
            for (AssignmentTransformationResult subTaskResult : this.subTaskResults.values()) {
                if (!subTaskResult.isTeamRestricted()) continue;
                return true;
            }
            return this.parentRestriction.isTeamRestricted();
        }

        private boolean isAnyResourceOrAssigneeRestricted() {
            for (AssignmentTransformationResult subTaskResult : this.subTaskResults.values()) {
                if (!subTaskResult.isResourceOrAssigneeRestriction()) continue;
                return true;
            }
            return this.parentRestriction.isResourceOrAssigneeRestriction();
        }

        private Set<IScheduleWarning> mergeWarnings() {
            HashSet warnings = Sets.newHashSet(this.parentRestriction.getWarnings());
            for (AssignmentTransformationResult subTaskResult : this.subTaskResults.values()) {
                warnings.addAll(subTaskResult.getWarnings());
            }
            return warnings;
        }

        private Set<IScheduleViolation> mergeViolations() {
            HashSet violations = Sets.newHashSet(this.parentRestriction.getViolations());
            for (AssignmentTransformationResult subTaskResult : this.subTaskResults.values()) {
                violations.addAll(subTaskResult.getViolations());
            }
            return violations;
        }

        public Builder addSubTaskRestriction(String subIssueId, AssignmentTransformationResult subIssueRestriction) {
            LOGGER.debug("add for sub issue %s: %s", subIssueId, subIssueRestriction);
            this.subTaskResults.put(subIssueId, subIssueRestriction);
            return this;
        }
    }
}

