/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.AnonymousWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UnstructuredSlotsDefinition
implements WorkSlotsDefinition {
    private final String groupId;
    private final TimeStepPresenceFunction timeStepPresenceFunction;
    private final int offset;

    public UnstructuredSlotsDefinition(String groupId, TimeStepPresenceFunction timeStepPresenceFunction) {
        this(groupId, timeStepPresenceFunction, 0);
    }

    public UnstructuredSlotsDefinition(String groupId, TimeStepPresenceFunction timeStepPresenceFunction, int offset) {
        this.groupId = groupId;
        this.timeStepPresenceFunction = timeStepPresenceFunction;
        this.offset = offset;
    }

    @Override
    public IWorkSlot getNextValidWorkSlotForReleaseTime(int releaseTime) {
        if (releaseTime < this.offset) {
            return new AnonymousWorkSlot(this.groupId, this.offset, this.offset, 0);
        }
        return new AnonymousWorkSlot(this.groupId, releaseTime, releaseTime, releaseTime - this.offset);
    }

    @Override
    public IWorkSlot getNextWorkSlot(IWorkSlot workSlot) {
        return this.getNextValidWorkSlotForReleaseTime(workSlot.getEnd() + 1);
    }

    @Override
    public List<IWorkSlot> getWorkSlotsBetween(int startTime, int endTime) {
        ArrayList slots = Lists.newArrayList();
        for (int i = Math.max(this.offset, startTime); i <= endTime; ++i) {
            slots.add(new AnonymousWorkSlot(this.groupId, i, i, i - this.offset));
        }
        return slots;
    }

    @Override
    public boolean isWorkSlotStrict() {
        return false;
    }

    @Override
    public IWorkSlot getNextWorkSlotWithFullPresence(int timeStep) {
        int searchIndex = Math.max(this.offset, timeStep);
        while (!this.timeStepPresenceFunction.getAt(searchIndex).booleanValue()) {
            ++searchIndex;
        }
        return this.getNextValidWorkSlotForReleaseTime(searchIndex);
    }

    @Override
    public IWorkSlot getWorkSlotWithIndex(int slotIndex) {
        int timeStep = slotIndex + this.offset;
        return new AnonymousWorkSlot(this.groupId, timeStep, timeStep, slotIndex);
    }

    @Override
    public int getStartTimeStep(int slotIndex) {
        return slotIndex + this.offset;
    }

    @Override
    public int getEndTimeStep(int slotIndex) {
        return slotIndex + this.offset;
    }

    @Override
    public int getDefaultSlotLength() {
        return 1;
    }

    @Override
    public Optional<IWorkSlot> tryGetWorkSlotWithId(String slotId) {
        return Optional.absent();
    }

    @Override
    public IWorkSlot getSlotOrNextForTimeStep(int timeStep) {
        List<IWorkSlot> workSlotsBetween = this.getWorkSlotsBetween(timeStep, timeStep);
        if (workSlotsBetween.isEmpty()) {
            return this.getWorkSlotWithIndex(0);
        }
        return workSlotsBetween.get(0);
    }

    @Override
    public boolean isRestrictedWorkSlot(int slotIndex) {
        return false;
    }
}

