/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.AnonymousWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.BaseScrumSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IdentifiableWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IntervalPadding;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.util.IdentifiableInterval;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.util.Precision;

public class VariableScrumWorkSlots
extends BaseScrumSlotsDefinition {
    private final List<IWorkSlot> irregularSlots;
    private final int episodeLength;
    private final int timeOffset;

    private VariableScrumWorkSlots(int weeks, String groupId, TimeStepPresenceFunction timeStepPresenceFunction, List<IWorkSlot> irregularSlots) {
        super(weeks, groupId, timeStepPresenceFunction);
        this.irregularSlots = irregularSlots;
        this.episodeLength = weeks * 7;
        this.timeOffset = irregularSlots.isEmpty() ? 0 : this.irregularSlots.get(irregularSlots.size() - 1).getEnd() + 1;
    }

    @Override
    public IWorkSlot getNextValidWorkSlotForReleaseTime(int releaseTime) {
        IWorkSlot workSlot = this.getSlotOrNextForTimeStep(releaseTime);
        if (workSlot.getStart() >= releaseTime) {
            return workSlot;
        }
        return this.getNextWorkSlot(workSlot);
    }

    @Override
    public boolean isRestrictedWorkSlot(int slotIndex) {
        if (!this.isIrregularIndex(slotIndex)) {
            return false;
        }
        return this.getWorkSlotWithIndex(slotIndex).isRestricted();
    }

    @Override
    public IWorkSlot getSlotOrNextForTimeStep(int timeStep) {
        if (this.timeOffset > timeStep) {
            return (IWorkSlot)this.findInIrregulars(timeStep).get();
        }
        int clearTime = timeStep - this.timeOffset;
        int clearIndex = (int)Precision.round((double)clearTime / (double)this.episodeLength, 0, 3);
        int indexOffset = this.irregularSlots.size();
        int start = this.timeOffset + this.episodeLength * clearIndex;
        return new AnonymousWorkSlot(this.groupId, start, start + this.episodeLength - 1, clearIndex + indexOffset);
    }

    private Optional<IWorkSlot> findInIrregulars(int timeStep) {
        for (IWorkSlot slot : this.irregularSlots) {
            if (slot.contains(timeStep)) {
                return Optional.of((Object)slot);
            }
            if (slot.getStart() <= timeStep) continue;
            return Optional.of((Object)slot);
        }
        return Optional.absent();
    }

    @Override
    public IWorkSlot getNextWorkSlot(IWorkSlot workSlot) {
        return this.getWorkSlotWithIndex(workSlot.getIndex() + 1);
    }

    @Override
    public IWorkSlot getWorkSlotWithIndex(int slotIndex) {
        if (this.isIrregularIndex(slotIndex)) {
            return this.irregularSlots.get(slotIndex);
        }
        int indexOffset = this.irregularSlots.size();
        int start = this.timeOffset + this.episodeLength * (slotIndex - indexOffset);
        return new AnonymousWorkSlot(this.groupId, start, start + this.episodeLength - 1, slotIndex);
    }

    @Override
    public int getStartTimeStep(int slotIndex) {
        return this.getWorkSlotWithIndex(slotIndex).getStart();
    }

    @Override
    public int getEndTimeStep(int slotIndex) {
        return this.getWorkSlotWithIndex(slotIndex).getEnd();
    }

    @Override
    public int getDefaultSlotLength() {
        return this.episodeLength;
    }

    @Override
    public Optional<IWorkSlot> tryGetWorkSlotWithId(final String slotId) {
        return Iterables.tryFind(this.irregularSlots, (Predicate)new Predicate<IWorkSlot>(){

            public boolean apply(IWorkSlot workSlot) {
                return slotId.equals(workSlot.tryGetId().orNull());
            }
        });
    }

    private boolean isIrregularIndex(int slotIndex) {
        return slotIndex < this.irregularSlots.size();
    }

    public static VariableScrumWorkSlots createWithDefaultPadding(String id, List<IdentifiableInterval> definedIntervals, TimeStepPresenceFunction timeStepPresenceFunction, int iterationLengthInWeeks, Set<String> restrictedIntervalIds, int offset) {
        return VariableScrumWorkSlots.create(id, definedIntervals, new IntervalPadding().createPaddingIntervals(definedIntervals, iterationLengthInWeeks * 7, offset), timeStepPresenceFunction, iterationLengthInWeeks, restrictedIntervalIds);
    }

    public static VariableScrumWorkSlots create(String id, List<IdentifiableInterval> definedIntervals, List<IIntegerInterval> paddedIntervals, TimeStepPresenceFunction timeStepPresenceFunction, int defaultWeekCount) {
        return VariableScrumWorkSlots.create(id, definedIntervals, paddedIntervals, timeStepPresenceFunction, defaultWeekCount, Sets.newHashSet());
    }

    private static VariableScrumWorkSlots create(String id, List<IdentifiableInterval> definedIntervals, List<IIntegerInterval> paddedIntervals, TimeStepPresenceFunction timeStepPresenceFunction, int defaultWeekCount, Set<String> restrictedIntervalIds) {
        List<IWorkSlot> irregular = VariableScrumWorkSlots.createIrregularSlots(definedIntervals, paddedIntervals, id, restrictedIntervalIds);
        return new VariableScrumWorkSlots(defaultWeekCount, id, timeStepPresenceFunction, irregular);
    }

    private static List<IWorkSlot> createIrregularSlots(List<IdentifiableInterval> definedIntervals, List<IIntegerInterval> paddedIntervals, String teamId, Set<String> restrictedIntervalIds) {
        ArrayList openDefined = Lists.newArrayList(definedIntervals);
        ArrayList openGenerated = Lists.newArrayList(paddedIntervals);
        ArrayList slots = Lists.newArrayList();
        for (int i = 0; i < definedIntervals.size() + paddedIntervals.size(); ++i) {
            IIntegerInterval next;
            if (VariableScrumWorkSlots.isNextDefinedInterval(openDefined, openGenerated)) {
                next = (IdentifiableInterval)openDefined.remove(0);
                slots.add(new IdentifiableWorkSlot(teamId, next.getStart(), next.getEnd(), i, next.getId(), restrictedIntervalIds.contains(next.getId())));
                continue;
            }
            next = (IIntegerInterval)openGenerated.remove(0);
            slots.add(new AnonymousWorkSlot(teamId, next.getStart(), next.getEnd(), i));
        }
        return slots;
    }

    private static boolean isNextDefinedInterval(List<IdentifiableInterval> openDefined, List<IIntegerInterval> openGenerated) {
        if (openDefined.isEmpty()) {
            return false;
        }
        if (openGenerated.isEmpty()) {
            return true;
        }
        return openDefined.get(0).getStart() < openGenerated.get(0).getStart();
    }
}

