/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.AnonymousWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.BaseScrumSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.math3.util.Precision;

@Immutable
public class WeeklyScrumWorkSlots
extends BaseScrumSlotsDefinition {
    private static final Log LOGGER = Log.with(WeeklyScrumWorkSlots.class);
    private final int episodeLength;

    public WeeklyScrumWorkSlots(String groupId, int weeks, TimeStepPresenceFunction timeStepPresenceFunction) {
        super(weeks, groupId, timeStepPresenceFunction);
        Preconditions.checkNotNull((Object)groupId, (Object)"group id must not be null");
        Preconditions.checkArgument((weeks > 0 ? 1 : 0) != 0, (Object)"number of weeks must be strictly positive");
        this.episodeLength = 7 * weeks;
    }

    @Override
    public IWorkSlot getWorkSlotWithIndex(int slotIndex) {
        AnonymousWorkSlot workSlot = new AnonymousWorkSlot(this.groupId, this.getStartTimeStep(slotIndex), this.getEndTimeStep(slotIndex), slotIndex);
        return workSlot;
    }

    @Override
    public IWorkSlot getNextValidWorkSlotForReleaseTime(int releaseTime) {
        Preconditions.checkArgument((releaseTime >= 0 ? 1 : 0) != 0, (Object)"time step must be greater or equal zero");
        int index = this.getSlotNumberWithTimestep(releaseTime);
        IWorkSlot workSlot = this.getWorkSlotWithIndex(index);
        if (workSlot.getStart() == releaseTime) {
            return workSlot;
        }
        return this.getNextWorkSlot(workSlot);
    }

    @Override
    public IWorkSlot getNextWorkSlot(IWorkSlot workSlot) {
        int index = workSlot.getIndex();
        return this.getWorkSlotWithIndex(index + 1);
    }

    @Override
    public int getStartTimeStep(int slotIndex) {
        return slotIndex * this.episodeLength;
    }

    @Override
    public int getEndTimeStep(int slotIndex) {
        return this.getStartTimeStep(slotIndex) + this.episodeLength - 1;
    }

    @Override
    public int getDefaultSlotLength() {
        return this.episodeLength;
    }

    @Override
    public Optional<IWorkSlot> tryGetWorkSlotWithId(String slotId) {
        return Optional.absent();
    }

    @Override
    public IWorkSlot getSlotOrNextForTimeStep(int timeStep) {
        if (timeStep < 0) {
            return this.getWorkSlotWithIndex(0);
        }
        return this.getWorkSlotWithIndex(this.getSlotNumberWithTimestep(timeStep));
    }

    @Override
    public boolean isRestrictedWorkSlot(int slotIndex) {
        return false;
    }

    private int getSlotNumberWithTimestep(int timeStep) {
        int cycleNumber = (int)Precision.round((double)timeStep / (double)this.episodeLength, 0, 3);
        return cycleNumber;
    }

    public static WeeklyScrumWorkSlots create(String teamId, TimeStepPresenceFunction timeStepPresenceFunction, int weeksPerSprint) {
        LOGGER.debug("create instance for team: %s", teamId);
        WeeklyScrumWorkSlots weeklyWorkSlots = new WeeklyScrumWorkSlots(teamId, weeksPerSprint, timeStepPresenceFunction);
        LOGGER.debug("created slots: %s", weeklyWorkSlots);
        return weeklyWorkSlots;
    }
}

