/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.plugins.jira.websections;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.plugins.PluginNotAvailableException;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.module.propertyset.PropertySet;
import com.radiantminds.plugins.jira.utils.RecentPlans;
import com.radiantminds.plugins.jira.utils.RecentlyVisitedPlan;
import com.radiantminds.plugins.jira.websections.PlanWebItemProvider;
import com.radiantminds.plugins.jira.websections.PlanWebItemProviderFactory;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.users.UserExtension;
import com.radiantminds.roadmap.jpo2.api.Portfolio2Exception;
import com.radiantminds.roadmap.jpo2.api.plans.Plan;
import com.radiantminds.roadmap.jpo2.api.plans.PlanListingServiceBridge;
import com.radiantminds.roadmap.jpo2.api.plans.PlanListingServiceBridgeProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class RecentPlansWebItemProvider
implements WebItemProvider {
    private static final Log LOGGER = Log.with(RecentPlansWebItemProvider.class);
    private final PlanWebItemProviderFactory planWebItemProviderFactory;
    private final JiraAuthenticationContext authenticationContext;
    private final UserPropertyManager userPropertyManager;
    private final PortfolioPlanPersistence planPersistence;
    private final UserExtension userExtension;
    private final PlanListingServiceBridgeProxy planListingServiceBridgeProxy;

    public RecentPlansWebItemProvider(PlanWebItemProviderFactory planWebItemProviderFactory, JiraAuthenticationContext authenticationContext, UserPropertyManager userPropertyManager, PortfolioPlanPersistence planPersistence, UserExtension userExtension, PlanListingServiceBridgeProxy planListingServiceBridgeProxy) {
        this.planWebItemProviderFactory = planWebItemProviderFactory;
        this.authenticationContext = authenticationContext;
        this.userPropertyManager = userPropertyManager;
        this.planPersistence = planPersistence;
        this.userExtension = userExtension;
        this.planListingServiceBridgeProxy = planListingServiceBridgeProxy;
    }

    public Iterable<WebItem> getItems(Map<String, Object> map) {
        try {
            ApplicationUser applicationUser = this.authenticationContext.getUser();
            PropertySet propertySet = this.getUserPropertySet(applicationUser);
            List<RecentlyVisitedPlan> recentPlans = this.getRecentlyVisitedPlans(propertySet);
            if (!recentPlans.isEmpty()) {
                ArrayList recentPlansWebItems = Lists.newArrayList();
                Map<Long, IPlan> portfolio1Plans = this.retrieveVisiblePortfolio1Plans();
                Map<Long, Plan> portfolio2Plans = this.getPorfolio2PlansOrEmptyMap(recentPlans);
                PlanWebItemProvider webItemProvider = this.planWebItemProviderFactory.createProvider();
                for (RecentlyVisitedPlan recentlyVisitedPlan : recentPlans) {
                    Object plan;
                    if (recentlyVisitedPlan.getJpoVersion().equals(2)) {
                        plan = portfolio2Plans.get(recentlyVisitedPlan.getPlanId());
                        if (plan == null) continue;
                        recentPlansWebItems.add(webItemProvider.createPortfolio2WebItem((Plan)plan, recentlyVisitedPlan.getScenarioId()));
                        continue;
                    }
                    plan = portfolio1Plans.get(recentlyVisitedPlan.getPlanId());
                    if (plan == null) continue;
                    recentPlansWebItems.add(webItemProvider.createPortfolio1WebItem((IPlan)plan));
                }
                return recentPlansWebItems;
            }
            return Lists.newArrayList();
        }
        catch (Exception e) {
            LOGGER.warnDebug(e, "Unable to create Portfolio menu entries.", new Object[0]);
            return Lists.newArrayList();
        }
    }

    private PropertySet getUserPropertySet(ApplicationUser applicationUser) {
        return applicationUser != null ? this.userPropertyManager.getPropertySet(applicationUser) : null;
    }

    private List<RecentlyVisitedPlan> getRecentlyVisitedPlans(PropertySet propertySet) {
        return propertySet != null ? RecentPlans.getPlans(this.planPersistence, propertySet) : Lists.newArrayList();
    }

    private Map<Long, IPlan> retrieveVisiblePortfolio1Plans() throws Exception {
        Map<String, IPlan> plansWithPermission = this.planPersistence.listPlansWithPermission(this.userExtension.getActiveUserData());
        HashMap plansById = Maps.newHashMap();
        for (String strKey : plansWithPermission.keySet()) {
            plansById.put(Long.parseLong(strKey), plansWithPermission.get(strKey));
        }
        return plansById;
    }

    private Map<Long, Plan> getPorfolio2PlansOrEmptyMap(List<RecentlyVisitedPlan> recentPlans) {
        HashMap portfolio2Plans;
        try {
            portfolio2Plans = this.getPortfolio2Plans(recentPlans);
        }
        catch (Exception e) {
            LOGGER.warnDebug(e, "Unable to retrieve live plans.", new Object[0]);
            portfolio2Plans = Maps.newHashMap();
        }
        return portfolio2Plans;
    }

    private Map<Long, Plan> getPortfolio2Plans(List<RecentlyVisitedPlan> recentPlans) {
        Iterable<RecentlyVisitedPlan> jpo2PlanIdStrings = this.filterJPO2Plans(recentPlans);
        Iterable<Long> jpoPlanIds = this.getPlanIds(jpo2PlanIdStrings);
        if (!Iterables.isEmpty(jpoPlanIds)) {
            try {
                return this.getMapOfPlansById(jpoPlanIds);
            }
            catch (PluginNotAvailableException | Portfolio2Exception e) {
                LOGGER.warnDebug(e, "Unable to retrieve live plans.", new Object[0]);
                return Maps.newHashMap();
            }
        }
        return Maps.newHashMap();
    }

    private Map<Long, Plan> getMapOfPlansById(Iterable<Long> jpoPlanIds) throws PluginNotAvailableException, Portfolio2Exception {
        PlanListingServiceBridge planListingServiceBridge = (PlanListingServiceBridge)this.planListingServiceBridgeProxy.get();
        List<Plan> plans = planListingServiceBridge.getPlans(Sets.newHashSet(jpoPlanIds));
        return Maps.newHashMap((Map)Maps.uniqueIndex(plans, (Function)new Function<Plan, Long>(){

            public Long apply(Plan plan) {
                return plan.getId();
            }
        }));
    }

    private Iterable<Long> getPlanIds(Iterable<RecentlyVisitedPlan> recentVisitedItems) {
        return Iterables.transform(recentVisitedItems, (Function)new Function<RecentlyVisitedPlan, Long>(){

            public Long apply(RecentlyVisitedPlan input) {
                return input.getPlanId();
            }
        });
    }

    private Iterable<RecentlyVisitedPlan> filterJPO2Plans(List<RecentlyVisitedPlan> recentPlans) {
        return Iterables.filter(recentPlans, (Predicate)new Predicate<RecentlyVisitedPlan>(){

            public boolean apply(@Nullable RecentlyVisitedPlan input) {
                return input != null && input.getJpoVersion() != null && input.getJpoVersion().equals(2);
            }
        });
    }
}

