/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.replanning;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.common.IReplannable;
import com.radiantminds.roadmap.common.data.entities.people.ISprint;
import com.radiantminds.roadmap.common.data.entities.people.ITeam;
import com.radiantminds.roadmap.common.data.entities.plans.FullContentSchedulingPlan;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.entities.plans.TrackerType;
import com.radiantminds.roadmap.common.data.entities.releases.IStream;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemStatus;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.estimate.DefaultEstimateExtractor;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.WorkItemRelationSQL;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.analytics.AnalyticsExtension;
import com.radiantminds.roadmap.common.extensions.issues.IssueSyncData;
import com.radiantminds.roadmap.common.extensions.issues.PortfolioToJiraSyncExtension;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.entities.progress.RestProgressConfiguration;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingSolution;
import com.radiantminds.roadmap.common.rest.services.replanning.RestModificationResult;
import com.radiantminds.roadmap.common.rest.services.workitems.constraints.WorkItemConstraintChecker;
import com.radiantminds.roadmap.common.scheduling.Calculation;
import com.radiantminds.roadmap.common.scheduling.Scheduling;
import com.radiantminds.roadmap.common.scheduling.entities.SchedulingPlanFactory;
import com.radiantminds.roadmap.common.utils.estimate.EstimateReplanningUtil;
import com.radiantminds.roadmap.common.utils.estimate.SuggestionMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.joda.time.Days;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;

public interface ReplanningServiceHandler {
    @AuthorizedPlanUserAccess(entityNeeded=true, incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On, incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response initiateReplanning(EntityContext<IPlan> var1, Long var2) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response finalizeReplanning(EntityContext<IPlan> var1, Long var2) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On, incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response cancelReplanning(EntityContext<IPlan> var1, Long var2) throws Exception;

    public static class Impl
    implements ReplanningServiceHandler {
        private static final Log LOGGER = Log.with(ReplanningServiceHandler.class);
        private static final String TEMPORAL_PLANNING_UNIT_NOT_COMPATIBLE = "temporal-planning-not-temporal-progress";
        private static final String POINT_PLANNING_UNIT_NOT_COMPATIBLE = "point-planning-not-point-progress";
        private final ActiveObjectsUtilities activeObjectsUtilities;
        private final AnalyticsExtension analyticsExtension;
        private final PortfolioPlanPersistence planPersistence;
        private final PortfolioWorkItemPersistence workItemPersistence;
        private final PortfolioEstimatePersistence estimatePersistence;
        private final PortfolioTeamPersistence teamPersistence;
        private final PortfolioReleasePersistence releasePersistence;
        private final SchedulingPlanFactory schedulingPlanFactory;
        private final Scheduling scheduling;
        private final WorkItemConstraintChecker workItemConstraintChecker;
        private final EstimateReplanningUtil estimateReplanningUtil;
        private final DefaultEstimateExtractor defaultEstimateExtractor;
        private final PortfolioToJiraSyncExtension syncExtension;
        private final WorkItemRelationSQL workItemRelationSql;

        public Impl(ActiveObjectsUtilities activeObjectsUtilities, AnalyticsExtension analyticsExtension, PortfolioPlanPersistence planPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioEstimatePersistence estimatePersistence, PortfolioTeamPersistence teamPersistence, PortfolioReleasePersistence releasePersistence, SchedulingPlanFactory schedulingPlanFactory, WorkItemExtension workItemExtension, PortfolioToJiraSyncExtension syncExtension, Scheduling scheduling) {
            this.activeObjectsUtilities = activeObjectsUtilities;
            this.analyticsExtension = analyticsExtension;
            this.planPersistence = planPersistence;
            this.workItemPersistence = workItemPersistence;
            this.estimatePersistence = estimatePersistence;
            this.teamPersistence = teamPersistence;
            this.releasePersistence = releasePersistence;
            this.schedulingPlanFactory = schedulingPlanFactory;
            this.scheduling = scheduling;
            this.workItemConstraintChecker = new WorkItemConstraintChecker(workItemPersistence);
            this.estimateReplanningUtil = new EstimateReplanningUtil(workItemPersistence, estimatePersistence, workItemExtension);
            this.defaultEstimateExtractor = new DefaultEstimateExtractor(workItemPersistence, planPersistence);
            this.syncExtension = syncExtension;
            this.workItemRelationSql = new WorkItemRelationSQL(activeObjectsUtilities);
        }

        @Override
        public Response initiateReplanning(EntityContext<IPlan> entityContext, Long date) throws Exception {
            this.analyticsExtension.publishReplanningInitiated(Impl.getDeltaToToday(date));
            IPlan plan = entityContext.getEntity();
            if (!plan.getInReplanning().booleanValue()) {
                if (date == null) {
                    return ResponseBuilder.badRequest(RestMessaging.error("replanning-date-not-set"));
                }
                plan.setReplanningDate(date);
                plan.setInReplanning(true);
                plan = this.planPersistence.persist(plan, false);
            }
            FullContentSchedulingPlan schedulingPlan = this.schedulingPlanFactory.create(plan.getId());
            Optional<String> suggestionErrorMessage = Impl.tryGetUnsuggestableErrorMessage(plan);
            SuggestionMode suggestionMode = SuggestionMode.FULL;
            if (suggestionErrorMessage.isPresent() || !((Boolean)Objects.firstNonNull((Object)schedulingPlan.getPlanConfiguration().getSuggestReplEstimates(), (Object)true)).booleanValue()) {
                suggestionMode = SuggestionMode.SIMPLE;
            }
            this.estimateReplanningUtil.applySuggestions(schedulingPlan, suggestionMode);
            ModificationResult modificationResult = Impl.createModificationResult(plan, (String)suggestionErrorMessage.orNull());
            return entityContext.ok(modificationResult);
        }

        private static ModificationResult createModificationResult(IPlan plan, @Nullable String suggestionError) {
            return new ModificationResult(plan.getReplanningVersion(), null, new RestModificationResult((Long)plan.getReplanningDate().get(), suggestionError));
        }

        private static Optional<String> tryGetUnsuggestableErrorMessage(IPlan plan) {
            PlanningUnit planningUnit = PlanningUnit.from(plan.getPlanConfiguration().getPlanningUnit());
            RestProgressConfiguration progressConfiguration = RestProgressConfiguration.from(plan.getPlanConfiguration());
            TrackerType trackerType = progressConfiguration.getTrackerType();
            if (planningUnit == PlanningUnit.DAYS || planningUnit == PlanningUnit.HOURS) {
                if (!trackerType.equals((Object)TrackerType.TimeBased)) {
                    return Optional.of((Object)TEMPORAL_PLANNING_UNIT_NOT_COMPATIBLE);
                }
            } else if (!trackerType.equals((Object)TrackerType.StoryPoints)) {
                return Optional.of((Object)POINT_PLANNING_UNIT_NOT_COMPATIBLE);
            }
            return Optional.absent();
        }

        @Override
        public Response finalizeReplanning(EntityContext<IPlan> entityContext, Long replanningVersion) throws Exception {
            IPlan plan = entityContext.getEntity();
            this.analyticsExtension.publishReplanningConfirmed(Impl.getDeltaToToday((Long)plan.getReplanningDate().orNull()));
            Long now = System.currentTimeMillis();
            LOGGER.info("Finalizing replanning...", new Object[0]);
            if (!Objects.equal((Object)replanningVersion, (Object)plan.getReplanningVersion())) {
                return ResponseBuilder.badRequest(RestMessaging.error("replanning-version-conflict", "Supplied replanning version is outdated."));
            }
            final Long replanningDate = (Long)plan.getReplanningDate().orNull();
            this.finalizeForAllReplannables(plan, new ReplanningCallback(){

                @Override
                public void apply(IReplannable replannable) {
                    replannable.applyReplanning(activeObjectsUtilities, replanningDate);
                    replannable.clearReplanning(activeObjectsUtilities);
                }
            });
            plan.setInReplanning(false);
            Impl.incrementReplanningVersion(plan);
            Long poorMansStopWatch = System.currentTimeMillis();
            this.planPersistence.persist(plan, false);
            LOGGER.debug("persisting of plan %s took %s ms", plan.getTitle(), System.currentTimeMillis() - poorMansStopWatch);
            LOGGER.info("Replanning finalized. Time elapsed: %s ms", System.currentTimeMillis() - now);
            return entityContext.ok();
        }

        private void finalizeForAllReplannables(IPlan plan, ReplanningCallback callback) throws Exception {
            Long poorMansStopWatch = System.currentTimeMillis();
            Long replanningDate = (Long)plan.getReplanningDate().orNull();
            IPlanConfiguration config = this.planPersistence.getPlanConfiguration(plan.getId());
            callback.apply(plan);
            LOGGER.debug("callback apply for plan %s took %s ms", plan.getTitle(), System.currentTimeMillis() - poorMansStopWatch);
            poorMansStopWatch = System.currentTimeMillis();
            this.planPersistence.persist(plan);
            LOGGER.debug("persisting plan %s took %s ms", plan.getTitle(), System.currentTimeMillis() - poorMansStopWatch);
            List<Object> workItemIdsToReplan = Lists.newArrayList();
            HashSet workItemIdsSetToDone = Sets.newHashSet();
            List<Object> workItemIds = Lists.newArrayList();
            poorMansStopWatch = System.currentTimeMillis();
            List<IWorkItem> workItemList = plan.getWorkItems();
            LOGGER.debug("loading workitems for plan %s took %s ms", plan.getTitle(), System.currentTimeMillis() - poorMansStopWatch);
            Long poorMansStopWatch2 = System.currentTimeMillis();
            workItemIds = this.getWorkItemIds(workItemList);
            workItemIdsToReplan = this.getWorkItemsIdsToReplan(workItemIds);
            LOGGER.debug("Replanning loop preparation for plan %s took %s ms", plan.getTitle(), System.currentTimeMillis() - poorMansStopWatch2);
            poorMansStopWatch2 = System.currentTimeMillis();
            Set<String> workItemsWithReplanningEstimates = this.workItemPersistence.getItemsWithReplanningEstimates(plan.getId());
            long applyReplanningWatch = 0L;
            long clearReplanningRelationsWatch = 0L;
            long copyCurrentToOriginalWatch = 0L;
            long applyEstimatesWatch = 0L;
            for (IWorkItem workItem : workItemList) {
                boolean replanToDone;
                String workItemId = workItem.getId();
                poorMansStopWatch = System.currentTimeMillis();
                boolean bl = replanToDone = workItem.getReplanningStatus() != null && WorkItemStatus.COMPLETED.is(workItem.getReplanningStatus());
                if (replanToDone || workItemsWithReplanningEstimates.contains(workItemId)) {
                    Optional<Double> defaultEstimate = this.defaultEstimateExtractor.defaultEstimateForWorkItem(workItem, config);
                    long beforeCopyCurrentToOriginal = System.currentTimeMillis();
                    this.estimatePersistence.copyCurrentToOriginalEstimates(workItemId, defaultEstimate, false);
                    copyCurrentToOriginalWatch += System.currentTimeMillis() - beforeCopyCurrentToOriginal;
                }
                long beforeApplyReplanning = System.currentTimeMillis();
                this.applyReplanning(workItem, replanningDate);
                applyReplanningWatch += System.currentTimeMillis() - beforeApplyReplanning;
                long beforeEstimateApply = System.currentTimeMillis();
                this.estimatePersistence.applyReplanning(workItemId, replanningDate);
                applyEstimatesWatch += System.currentTimeMillis() - beforeEstimateApply;
                if (replanToDone && workItem.getChildren().size() == 0) {
                    workItemIdsSetToDone.add(workItemId);
                }
                LOGGER.trace("replanning operation for workitem %s took %s ms", workItem.getTitle(), System.currentTimeMillis() - poorMansStopWatch);
            }
            LOGGER.debug("Replanning loop for plan %s took %s ms", plan.getTitle(), System.currentTimeMillis() - poorMansStopWatch2);
            long beforeClearReplanningRelations = System.currentTimeMillis();
            this.workItemRelationSql.deleteReplanningRelationsForWorkItems(workItemIds);
            LOGGER.debug("\tapplyReplanning: %s ms", applyReplanningWatch);
            LOGGER.debug("\tclearReplanningRelations: %s ms", clearReplanningRelationsWatch += System.currentTimeMillis() - beforeClearReplanningRelations);
            LOGGER.debug("\tcopyCurrentToOriginalEstimates: %s ms", copyCurrentToOriginalWatch);
            LOGGER.debug("\testimate.applyReplanning: %s ms", applyEstimatesWatch);
            poorMansStopWatch2 = System.currentTimeMillis();
            this.clearReplanning(workItemIds);
            LOGGER.debug("Clear replanning for plan %s took %s ms", plan.getTitle(), System.currentTimeMillis() - poorMansStopWatch2);
            if (workItemIdsToReplan.size() > 0) {
                this.workItemPersistence.deleteResourceAssignments(workItemIdsToReplan, false);
                this.workItemPersistence.replanResourceAssignments(workItemIdsToReplan);
            }
            this.replanToDone(plan.getId(), workItemIdsSetToDone);
            Sets.SetView syncRelevantWorkItemIds = Sets.union(workItemsWithReplanningEstimates, (Set)workItemIdsSetToDone);
            this.triggerItemUpdate((Set<String>)syncRelevantWorkItemIds);
        }

        private void triggerItemUpdate(Set<String> workItemIds) {
            Long poorMansStopWatch = System.currentTimeMillis();
            this.syncExtension.syncWorkItemsToIssues(IssueSyncData.createEstimateSyncFor(workItemIds));
            LOGGER.debug("itemUpdate for %s workitems took %s ms", workItemIds.size(), System.currentTimeMillis() - poorMansStopWatch);
        }

        private void clearReplanning(List<String> workItemIds) throws Exception {
            try {
                this.workItemRelationSql.setReplanningStatus(workItemIds, null);
                this.estimatePersistence.clearReplanningEstimatesBulk(workItemIds);
            }
            catch (Exception ex) {
                LOGGER.errorDebug(ex, "Exception while clearing replanning data.", new Object[0]);
                throw ex;
            }
        }

        private void applyReplanning(IWorkItem workItem, Long replanningDate) throws SQLException {
            String workItemId = workItem.getId();
            try {
                Optional<ISprint> sprint;
                Optional<String> replanningStreamId;
                Map<String, Optional<String>> targets = this.workItemRelationSql.getReplanningRelationTargets(workItemId);
                if (targets.get("team") != null) {
                    Optional<String> replanningTeamId = targets.get("team");
                    if (workItem.getTeam().isPresent() && !((ITeam)workItem.getTeam().get()).getId().equals(replanningTeamId.orNull())) {
                        this.workItemRelationSql.setSprint(workItemId, null);
                    }
                    this.workItemRelationSql.setTeam(workItemId, (String)replanningTeamId.orNull());
                }
                if ((replanningStreamId = targets.get("stream")) != null) {
                    this.workItemRelationSql.setStream(workItem.getId(), (String)replanningStreamId.orNull());
                    Optional<String> replanningReleaseId = targets.get("release");
                    String safeReplanningReleaseId = replanningReleaseId == null ? null : (String)replanningReleaseId.orNull();
                    this.workItemRelationSql.setRelease(workItemId, safeReplanningReleaseId);
                }
                if (workItem.getReplanningStatus() != null) {
                    this.workItemRelationSql.setStatus(workItemId, workItem.getReplanningStatus());
                }
                if (replanningDate != null && (sprint = workItem.getSprint()).isPresent() && ((ISprint)sprint.get()).getEndDate() < replanningDate) {
                    this.workItemRelationSql.setSprint(workItemId, null);
                }
            }
            catch (SQLException ex) {
                LOGGER.errorDebug(ex, "Exception while applying replanning data to workItem.", new Object[0]);
                throw ex;
            }
        }

        private List<String> getWorkItemIds(List<IWorkItem> workItemList) {
            List workItemIds = Lists.transform(workItemList, (Function)new Function<IWorkItem, String>(){

                public String apply(@Nullable IWorkItem input) {
                    return input.getId();
                }
            });
            return workItemIds;
        }

        private List<String> getWorkItemsIdsToReplan(List<String> workItemIds) throws SQLException {
            return this.workItemPersistence.getReplanningRelationWorkItemIds("team", workItemIds);
        }

        private void replanToDone(String planId, Set<String> workItemIdsSetToDone) throws Exception {
            Long poorMansStopWatch = System.currentTimeMillis();
            Optional<Calculation> green = this.scheduling.getSolutionForPlan(planId);
            for (String id : workItemIdsSetToDone) {
                ArrayList resourceIds;
                Set<String> greenResources;
                Set<String> itemResources;
                IWorkItem item = (IWorkItem)this.workItemPersistence.get(id);
                if (this.workItemConstraintChecker.isAssignable(item.getId()) != null || !green.isPresent()) continue;
                RestSchedulingSolution solution = ((Calculation)green.get()).getTransferableSolution();
                if (solution == null) {
                    return;
                }
                this.fixReleaseIfSetInGreenData(item, solution);
                Set<String> resourceIdsForWorkItem = solution.getResourceIdsForWorkItem(id);
                Set<String> teamIdsForWorkItem = solution.getTeamIdsForResources(resourceIdsForWorkItem);
                String greenTeam = Impl.getGreen(teamIdsForWorkItem);
                String teamOnItem = null;
                if (!item.getTeam().isPresent()) {
                    if (greenTeam != null && this.teamPersistence.exists(greenTeam)) {
                        this.workItemPersistence.setTeam(id, greenTeam);
                        teamOnItem = greenTeam;
                    }
                } else {
                    teamOnItem = ((ITeam)item.getTeam().get()).getId();
                }
                if (teamOnItem == null || greenTeam == null || !teamOnItem.equals(greenTeam) || (itemResources = this.workItemPersistence.getResourceAssignmentsForWorkItem(item.getId(), false)) != null && !itemResources.isEmpty() || (greenResources = resourceIdsForWorkItem) == null || greenResources.size() == 1 && greenResources.iterator().next().startsWith("team-resource-") || !this.workItemPersistence.validateTeamSprintResourceAssignment(teamOnItem, null, resourceIds = Lists.newArrayList(greenResources))) continue;
                this.workItemPersistence.setTeamSprintResourceAssignment(item.getId(), teamOnItem, null, resourceIds, false);
            }
            LOGGER.debug("replanToDone for plan %s took %s ms", planId, System.currentTimeMillis() - poorMansStopWatch);
        }

        private void fixReleaseIfSetInGreenData(IWorkItem item, RestSchedulingSolution solution) throws Exception {
            String greenRelease;
            String id = item.getId();
            if (!item.getRelease().isPresent() && (greenRelease = Impl.getGreen(solution.getReleaseIdsForWorkItem(id))) != null) {
                if (!this.releasePersistence.exists(greenRelease)) {
                    return;
                }
                if (!this.workItemPersistence.validateStreamReleaseAssignment(((IStream)item.getStream().get()).getId(), greenRelease)) {
                    return;
                }
                this.workItemPersistence.setRelease(id, greenRelease);
            }
        }

        private static String getGreen(Set<String> ids) {
            if (ids != null && ids.size() == 1) {
                return ids.iterator().next();
            }
            return null;
        }

        @Override
        public Response cancelReplanning(EntityContext<IPlan> entityContext, Long replanningVersion) throws Exception {
            Long poorMansStopWatch = System.currentTimeMillis();
            IPlan plan = entityContext.getEntity();
            this.analyticsExtension.publishReplanningCancelled(Impl.getDeltaToToday((Long)plan.getReplanningDate().orNull()));
            if (!Objects.equal((Object)replanningVersion, (Object)plan.getReplanningVersion())) {
                return ResponseBuilder.badRequest(RestMessaging.error("replanning-version-conflict", "Supplied replanning version is outdated."));
            }
            this.clearAllReplannables(plan, new ReplanningCallback(){

                @Override
                public void apply(IReplannable replannable) {
                    replannable.clearReplanning(activeObjectsUtilities);
                }
            });
            plan.setInReplanning(false);
            Impl.incrementReplanningVersion(plan);
            this.planPersistence.persist(plan, false);
            LOGGER.info("cancel replanning took %s ms", System.currentTimeMillis() - poorMansStopWatch);
            return entityContext.ok();
        }

        private void clearAllReplannables(IPlan plan, ReplanningCallback callback) throws Exception {
            callback.apply(plan);
            this.planPersistence.persist(plan, false);
            Long poorMansStopWatch = System.currentTimeMillis();
            List<IWorkItem> workItemList = plan.getWorkItems();
            LOGGER.debug("Getting workItems for plan %s took %s ms.", plan.getTitle(), System.currentTimeMillis() - poorMansStopWatch);
            List<String> workItemIds = this.getWorkItemIds(workItemList);
            this.clearReplanning(workItemIds);
            this.estimatePersistence.clearReplanningEstimatesBulk(workItemIds);
            this.workItemPersistence.deleteResourceAssignments(workItemIds, true);
            this.workItemRelationSql.deleteReplanningRelationsForWorkItems(workItemIds);
        }

        private static void incrementReplanningVersion(IPlan plan) {
            Long replanningVersion = plan.getReplanningVersion();
            if (replanningVersion == null) {
                replanningVersion = 0L;
            }
            Long l = replanningVersion;
            Long l2 = replanningVersion = Long.valueOf(replanningVersion + 1L);
            plan.setReplanningVersion(replanningVersion);
        }

        private static Long getDeltaToToday(Long time) {
            if (time == null) {
                return null;
            }
            int days = Days.daysBetween((ReadablePartial)LocalDateTime.fromDateFields((Date)new Date()).withMillisOfDay(0), (ReadablePartial)LocalDateTime.fromDateFields((Date)new Date(time))).getDays();
            return days;
        }

        private static interface ReplanningCallback {
            public void apply(IReplannable var1);
        }
    }
}

