/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.teamresource;

import com.google.common.base.Objects;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.BulkEntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.assignment.RestBulkTeamResourceAssignment;
import com.radiantminds.roadmap.common.rest.entities.assignment.RestTeamResourceAssignment;
import com.radiantminds.roadmap.common.rest.services.common.OperationExecutor;
import com.radiantminds.roadmap.common.rest.services.workitems.teamresource.WorkItemTeamResourceServiceHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/workitems/bulk/resourceAssignment")
@Component
public class WorkItemBulkResourceAssignmentService {
    private final WorkItemTeamResourceServiceHandler handler;

    @Autowired
    public WorkItemBulkResourceAssignmentService(SecuredInvocationHandlerFactory handlerFactory, OperationExecutor operationExecutor, PortfolioWorkItemPersistence workItemPersistence, PortfolioTeamPersistence teamPersistence) {
        this.handler = handlerFactory.createProxy(WorkItemTeamResourceServiceHandler.class, new WorkItemTeamResourceServiceHandler.Impl(operationExecutor, workItemPersistence, teamPersistence), workItemPersistence);
    }

    @PUT
    public Response setAssignmentInBulk(@QueryParam(value="planVersion") String expectedPlanVersion, RestBulkTeamResourceAssignment assignment) throws Exception {
        return this.handler.setResourceAssignmentsInBulk(BulkEntityContext.from(assignment.getIds()), (RestTeamResourceAssignment)Objects.firstNonNull((Object)assignment.getAssignment(), (Object)new RestTeamResourceAssignment(null, null, new String[0])));
    }

    @PUT
    @Path(value="/replanning")
    public Response setReplanningAssignmentInBulk(@QueryParam(value="planVersion") String expectedPlanVersion, RestBulkTeamResourceAssignment assignment) throws Exception {
        return this.handler.setReplanningResourceAssignmentsInBulk(BulkEntityContext.from(assignment.getIds()), (RestTeamResourceAssignment)Objects.firstNonNull((Object)assignment.getAssignment(), (Object)new RestTeamResourceAssignment(null, null, new String[0])));
    }
}

