/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.solution;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IEpisodeSchedule;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.joda.time.Interval;

class ReleaseTransformer {
    private final ITimeTransformer timeTransformer;

    ReleaseTransformer(ITimeTransformer timeTransformer) {
        this.timeTransformer = timeTransformer;
    }

    Map<String, Interval> transform(LinkedHashSet<IEpisodeSchedule> episodeSchedulesPrioOrdered) {
        HashMap releaseIntervals = Maps.newHashMap();
        for (IEpisodeSchedule episodeSchedule : episodeSchedulesPrioOrdered) {
            if (episodeSchedule.getLength() <= 0) continue;
            long startInstant = this.timeTransformer.getInstant(episodeSchedule.getStart());
            long endInstant = this.timeTransformer.getInstant(episodeSchedule.getEnd());
            Interval interval = new Interval(startInstant, endInstant);
            releaseIntervals.put(episodeSchedule.getId(), interval);
        }
        return releaseIntervals;
    }
}

