/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.utils.meta;

import com.atlassian.pocketknife.api.logging.Log;
import com.radiantminds.roadmap.common.rest.exceptions.ExceptionWrapper;
import com.radiantminds.roadmap.common.utils.JPOVersion;
import java.io.InputStream;
import java.util.Properties;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.stereotype.Component;

@Component
public class MetaDataUtils {
    private static final Log LOGGER = Log.with(MetaDataUtils.class);
    private final JPOVersion version;
    private final DateTime buildTimestamp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaDataUtils() {
        JPOVersion localVersion = null;
        DateTime localBuildTimestamp = null;
        InputStream stream = null;
        try {
            Properties properties = new Properties();
            stream = ExceptionWrapper.class.getResourceAsStream("/build.properties");
            properties.load(stream);
            String version = properties.getProperty("version");
            localVersion = new JPOVersion(version);
            localBuildTimestamp = ISODateTimeFormat.dateTime().parseDateTime(properties.getProperty("timestamp"));
        }
        catch (Exception ex) {
            LOGGER.warn("Could not retrieve information from file build.properties.", new Object[0]);
            LOGGER.exception(ex, Log.LogLevel.WARN);
            localVersion = new JPOVersion(0, 0, 0, "Unknown");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception ex) {
                    LOGGER.warn("Could not retrieve build number from file build.properties.", new Object[0]);
                    LOGGER.exception(ex, Log.LogLevel.WARN);
                }
            }
        }
        this.buildTimestamp = localBuildTimestamp;
        this.version = localVersion;
    }

    public DateTime getBuildTimestamp() {
        return this.buildTimestamp;
    }

    public JPOVersion getVersion() {
        return this.version;
    }
}

