/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.features;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.api.FeatureAccessor;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.extensions.features.FeatureExtension;
import com.radiantminds.roadmap.jira.common.components.extension.features.Feature;
import com.radiantminds.roadmap.jira.common.components.extension.features.Features;
import com.radiantminds.roadmap.jira.common.components.utils.DevelopmentMode;
import com.radiantminds.roadmap.jira.common.components.utils.Distribution;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraFeatureExtension
implements FeatureExtension,
FeatureAccessor {
    public static final int PLANNING_HORIZON = 1825;
    private static final Log LOGGER = Log.with(JiraFeatureExtension.class);
    private final FeatureManager featureManager;

    @Autowired
    public JiraFeatureExtension(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    @Override
    public boolean isUnlimitedPlanningHorizonEnabled() {
        return this.test(Features.UNLIMITED_PLANNING_HORIZON);
    }

    @Override
    public boolean isAutomaticCalculationOptionEnabled() {
        return this.test(Features.AUTOMATIC_CALCULATION_OPTION);
    }

    @Override
    public boolean isFeedbackButtonEnabled() {
        return this.test(Features.FEEDBACK_BUTTON);
    }

    @Override
    public boolean isErrorServerDetailsEnabled() {
        return this.test(Features.ERROR_SERVER_DETAILS);
    }

    @Override
    public boolean isInvertedDependencyCreationEnabled() {
        return this.test(Features.INVERTED_DEPENDENCY_CREATION);
    }

    @Override
    public boolean isClientSideExceptionsBummerEnabled() {
        return this.test(Features.ERROR_CLIENT_EXCEPTIONS);
    }

    @Override
    public boolean isTimeLineAnonymized() {
        return this.test(Features.TIME_LINE_ANONYMIZED);
    }

    @Override
    public boolean isBusinessValueColumnEnabled() {
        return this.test(Features.BUSINESS_VALUE_COLUMN);
    }

    @Override
    public boolean isClassicPlansSunset() {
        return this.test(Features.CLASSIC_PLANS_DISCONTINUED);
    }

    @Override
    public boolean isLoadingLimitsConfigurable() {
        return this.test(Features.LOADING_LIMITS_CONFIGURABLE);
    }

    @Override
    public int getPlanningHorizonInDays() {
        if (this.isUnlimitedPlanningHorizonEnabled()) {
            return 10950;
        }
        return 1825;
    }

    @Override
    public boolean isEnabled(final String key) {
        Predicate<Feature> predicate = new Predicate<Feature>(){

            public boolean apply(@Nullable Feature feature) {
                return feature.getKey().equals(key);
            }
        };
        Optional feature = Iterables.tryFind((Iterable)Lists.newArrayList((Object[])Features.values()), (Predicate)predicate);
        if (feature.isPresent()) {
            return this.test((Feature)feature.get());
        }
        LOGGER.warn("Unknown feature %s; returning false.", key);
        return false;
    }

    protected boolean test(Feature feature) {
        String key;
        if (feature.isInvertable() && this.featureManager.isEnabled(feature.getKey() + ".disabled")) {
            return false;
        }
        if (this.featureManager.isEnabled(feature.getKey())) {
            return true;
        }
        if (feature.isAllowDevModeHack() && DevelopmentMode.isOn() && (key = System.getProperty(feature.getKey())) != null) {
            return "true".equals(key.toLowerCase());
        }
        if (Distribution.isOnDemand(this.featureManager)) {
            return feature.getOnDemandDefault();
        }
        return feature.getBTFDefault();
    }
}

