/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldNotAvailableException;
import com.radiantminds.roadmap.common.data.entities.plans.TrackerType;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressConfiguration;
import com.radiantminds.roadmap.jira.common.components.agile.JiraAgileAccessor;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.RetrievedJiraIssue;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.FieldBasedSelfProgressExtractor;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.NoProgressProgressHandler;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.ProgressException;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.ResolutionBasedSelfProgressExtractor;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.ResolutionBasedStoryPointSelfProgressExtractor;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.SelfProgressExtractor;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.TimeBasedSelfProgressExtractor;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.TimeWeightedStoryPointSelfProgressExtractor;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFields;
import java.util.Map;

public abstract class ProgressDataExtractorFactory {
    private static final Log LOGGER = Log.with(ProgressDataExtractorFactory.class);

    public static SelfProgressExtractor createInstance(ProgressConfiguration progressConfiguration, JiraAgileAccessor agileAccessor, CustomFields customFields, Map<String, RetrievedJiraIssue> issues) throws ProgressException {
        TrackerType progressTrackerType = progressConfiguration.getTrackerType();
        switch (progressTrackerType) {
            case StoryPoints: {
                if (agileAccessor.isUsable()) {
                    String storyPointSubTaskMode = progressConfiguration.getStoryPointSubTaskMode();
                    try {
                        if ("time".equals(storyPointSubTaskMode)) {
                            return TimeWeightedStoryPointSelfProgressExtractor.createInstance(customFields, issues);
                        }
                        if ("resolved".equals(storyPointSubTaskMode)) {
                            return ResolutionBasedStoryPointSelfProgressExtractor.createInstance(customFields, issues);
                        }
                        if ("none".equals(storyPointSubTaskMode)) {
                            return FieldBasedSelfProgressExtractor.createStoryPointExtractor(customFields, issues);
                        }
                        throw new IllegalArgumentException("Field-based progress is not available.");
                    }
                    catch (AgileNotAvailableException e) {
                        LOGGER.error("Agile must be available for story point progress tracking", new Object[0]);
                        throw new ProgressException("JIRA Agile is not available");
                    }
                    catch (AgileCustomFieldNotAvailableException e) {
                        LOGGER.error("Custom field must be available for story point progress tracking", new Object[0]);
                        throw new ProgressException("Custom field is not available");
                    }
                }
                return new NoProgressProgressHandler();
            }
            case ResolvedCount: {
                return new ResolutionBasedSelfProgressExtractor();
            }
            case TimeBased: {
                return new TimeBasedSelfProgressExtractor(progressConfiguration.isCompleteIfResolved());
            }
            case Manual: {
                throw new IllegalArgumentException("Field-based progress is not available.");
            }
        }
        throw new ProgressException("no available progress tracker");
    }
}

