/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.issues.IssueSyncData;
import com.radiantminds.roadmap.common.extensions.issues.PortfolioToJiraSyncExtension;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.JiraSyncTracker;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.EstimateSyncTaskFactoryProvider;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.JiraIssueUpdater;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.PlanInformation;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.PortfolioToJiraSyncConfiguration;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.PortfolioToJiraSyncData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.PortfolioToJiraSyncDataProvider;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.StageInformation;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.SyncTaskFactory;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.TitleSyncTaskFactory;
import com.radiantminds.roadmap.jira.common.components.issues.sync.SyncTask;
import com.radiantminds.roadmap.jira.common.components.issues.sync.tasks.DetailsSyncTask;
import com.radiantminds.roadmap.jira.common.components.sync.SynchronizationFlagHandler;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFields;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.JiraAgileCustomFieldData;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultPortfolioToJiraSyncExtension
implements PortfolioToJiraSyncExtension {
    private static final Log LOGGER = Log.with(DefaultPortfolioToJiraSyncExtension.class);
    private final SynchronizationFlagHandler flagHandler;
    private final PortfolioToJiraSyncDataProvider syncDataProvider;
    private final JiraIssueUpdater jiraIssueUpdater;
    private final CustomFields customFields;
    private final EstimateSyncTaskFactoryProvider estimateSyncTaskFactoryProvider;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PortfolioWorkItemPersistence workItemPersistence;
    private final PortfolioPlanPersistence planPersistence;
    private final PortfolioStagePersistence stagePersistence;

    @Autowired
    public DefaultPortfolioToJiraSyncExtension(SynchronizationFlagHandler flagHandler, PortfolioToJiraSyncDataProvider syncDataProvider, JiraIssueUpdater jiraIssueUpdater, CustomFields customFields, EstimateSyncTaskFactoryProvider estimateSyncTaskFactoryProvider, JiraAuthenticationContext jiraAuthenticationContext, PortfolioWorkItemPersistence workItemPersistence, PortfolioPlanPersistence planPersistence, PortfolioStagePersistence stagePersistence) {
        this.flagHandler = flagHandler;
        this.syncDataProvider = syncDataProvider;
        this.jiraIssueUpdater = jiraIssueUpdater;
        this.customFields = customFields;
        this.estimateSyncTaskFactoryProvider = estimateSyncTaskFactoryProvider;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.workItemPersistence = workItemPersistence;
        this.planPersistence = planPersistence;
        this.stagePersistence = stagePersistence;
    }

    @Override
    public void syncWorkItemToIssues(IssueSyncData issueSyncData) {
        this.syncWorkItemsToIssues(Lists.newArrayList((Object[])new IssueSyncData[]{issueSyncData}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncWorkItemsToIssues(List<IssueSyncData> issueSyncData) {
        try {
            Optional<JiraAgileCustomFieldData> customFieldData;
            ApplicationUser user = this.jiraAuthenticationContext.getUser();
            if (user == null) {
                LOGGER.debug("syncWorkItemsToIssues called without available user information.", new Object[0]);
                return;
            }
            JiraSyncTracker.recordNewSyncCall();
            if (!Iterables.any(issueSyncData, IssueSyncData.isPersisted())) {
                return;
            }
            Optional<String> planId = this.getPlanId(issueSyncData);
            if (!planId.isPresent()) {
                return;
            }
            IPlanConfiguration planConfiguration = this.planPersistence.getPlanConfiguration((String)planId.get());
            PlanInformation planInformation = PlanInformation.create(planConfiguration);
            List<PortfolioToJiraSyncData> synchronizationData = this.syncDataProvider.getSynchronizationData(issueSyncData, planInformation, customFieldData = this.getAgileDataIfNeededAndAvailable(issueSyncData, planInformation));
            if (synchronizationData.isEmpty()) {
                return;
            }
            StageInformation stageInformation = StageInformation.create(this.stagePersistence.listCustom((String)planId.get()));
            SyncTaskFactory estimateSyncTaskFactory = this.estimateSyncTaskFactoryProvider.createFactory(stageInformation, planInformation, customFieldData);
            TitleSyncTaskFactory titleSyncTaskFactory = new TitleSyncTaskFactory(customFieldData);
            for (PortfolioToJiraSyncData data : synchronizationData) {
                for (IExtensionLink link : data.getExtensionLinks()) {
                    Optional<IStage> stage = stageInformation.getStageForLink(link.getExtensionKey());
                    Optional<SyncTask> titleTask = titleSyncTaskFactory.createTask(data, stage);
                    Optional<SyncTask> descriptionTask = this.createDescriptionSyncTask(data);
                    Optional<SyncTask> estimateTask = estimateSyncTaskFactory.createTask(data, stage);
                    Set<SyncTask> syncTasks = DefaultPortfolioToJiraSyncExtension.toSet(titleTask, descriptionTask, estimateTask);
                    if (syncTasks.isEmpty()) continue;
                    try {
                        this.flagHandler.startJiraUpdate();
                        this.jiraIssueUpdater.updateIssue(syncTasks, data.getId(), link.getExtensionLink());
                    }
                    finally {
                        this.flagHandler.endJiraUpdate();
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to synchronize work item to JIRA issues.", new Object[0]);
            LOGGER.exception(ex, Log.LogLevel.ERROR);
        }
    }

    private Optional<String> getPlanId(List<IssueSyncData> issueSyncData) {
        for (IssueSyncData data : issueSyncData) {
            String workItemId = data.getId();
            if (workItemId == null) continue;
            try {
                return Optional.of((Object)this.workItemPersistence.getEntityInfo(workItemId).getPlanId());
            }
            catch (Exception ex) {
                LOGGER.error("Failed to retrieve plan ID for work item %s.", workItemId);
                LOGGER.exception(ex, Log.LogLevel.ERROR);
                return Optional.absent();
            }
        }
        return Optional.absent();
    }

    private Optional<SyncTask> createDescriptionSyncTask(PortfolioToJiraSyncData data) {
        if (data.getDescription().isPresent()) {
            return Optional.of((Object)new DetailsSyncTask((String)data.getDescription().get()));
        }
        return Optional.absent();
    }

    private Optional<JiraAgileCustomFieldData> getAgileDataIfNeededAndAvailable(List<IssueSyncData> issueSyncData, PlanInformation planInformation) {
        if (DefaultPortfolioToJiraSyncExtension.requireAgile(issueSyncData, planInformation)) {
            return this.customFields.tryGetJiraAgileData();
        }
        return Optional.absent();
    }

    private static boolean requireAgile(List<IssueSyncData> issueSyncData, PlanInformation planInformation) {
        boolean hasEstimateUpdate;
        boolean hasTitleUpdate;
        PortfolioToJiraSyncConfiguration syncConfiguration = planInformation.getSyncConfiguration();
        if (syncConfiguration.isSyncTitle() && (hasTitleUpdate = Iterables.any(issueSyncData, (Predicate)new Predicate<IssueSyncData>(){

            public boolean apply(IssueSyncData issueSyncData) {
                return issueSyncData.getTitle().isPresent();
            }
        }))) {
            return true;
        }
        return syncConfiguration.isSyncEstimates() && PlanningUnit.STORY_POINTS == planInformation.getPlanningUnit() && (hasEstimateUpdate = Iterables.any(issueSyncData, (Predicate)new Predicate<IssueSyncData>(){

            public boolean apply(IssueSyncData issueSyncData) {
                return issueSyncData.isSyncEstimate();
            }
        }));
    }

    private static <T> Set<T> toSet(Optional<T> ... optionals) {
        HashSet retVal = Sets.newHashSet();
        for (Optional<T> optional : optionals) {
            if (!optional.isPresent()) continue;
            retVal.add(optional.get());
        }
        return retVal;
    }
}

