/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.utils;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.pocketknife.api.logging.Log;
import java.util.Date;
import java.util.TimeZone;

public class JiraTimeZoneUtil {
    private static final Log LOGGER = Log.with(JiraTimeZoneUtil.class);

    public static TimeZone getJiraDefaultTimeZone(ApplicationProperties applicationProperties) {
        try {
            String jiraTimeZone = applicationProperties.getString("jira.default.timezone");
            TimeZone timeZone = jiraTimeZone != null ? TimeZone.getTimeZone(jiraTimeZone) : TimeZone.getDefault();
            return timeZone;
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to extract JIRA default timezone. Using system time zone instead.", new Object[0]);
            LOGGER.exception(ex, Log.LogLevel.WARN);
            return TimeZone.getDefault();
        }
    }

    public static Date removeTimeZoneOffset(Date date, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        long time = date.getTime();
        time -= (long)timeZone.getOffset(time);
        return new Date(time);
    }

    public static Date addTimeZoneOffset(Date date, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        long time = date.getTime();
        time += (long)timeZone.getOffset(time);
        return new Date(time);
    }
}

