/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.group;

import com.mysema.commons.lang.Pair;
import com.mysema.query.group.AbstractGroupExpression;
import com.mysema.query.group.GroupCollector;
import com.mysema.query.group.GroupExpression;
import com.mysema.query.group.QPair;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

class GMap<K, V>
extends AbstractGroupExpression<Pair<K, V>, Map<K, V>> {
    private static final long serialVersionUID = 7106389414200843920L;

    public GMap(QPair<K, V> qpair) {
        super(Map.class, qpair);
    }

    @Override
    public GroupCollector<Pair<K, V>, Map<K, V>> createGroupCollector() {
        return new GroupCollector<Pair<K, V>, Map<K, V>>(){
            private final Map<K, V> map = new LinkedHashMap();

            @Override
            public void add(Pair<K, V> pair) {
                this.map.put(pair.getFirst(), pair.getSecond());
            }

            @Override
            public Map<K, V> get() {
                return this.map;
            }
        };
    }

    static class Mixin<K, V, T, U, R extends Map<? super T, ? super U>>
    extends AbstractGroupExpression<Pair<K, V>, R> {
        private static final long serialVersionUID = 1939989270493531116L;
        private final GroupExpression<Pair<T, U>, R> mixin;
        private final GroupExpression<K, T> keyExpression;
        private final GroupExpression<V, U> valueExpression;

        public Mixin(GroupExpression<K, T> keyExpression, GroupExpression<V, U> valueExpression, AbstractGroupExpression<Pair<T, U>, R> mixin) {
            super(mixin.getType(), QPair.create(keyExpression.getExpression(), valueExpression.getExpression()));
            this.keyExpression = keyExpression;
            this.valueExpression = valueExpression;
            this.mixin = mixin;
        }

        @Override
        public GroupCollector<Pair<K, V>, R> createGroupCollector() {
            return new GroupCollectorImpl();
        }

        private class GroupCollectorImpl
        implements GroupCollector<Pair<K, V>, R> {
            private final GroupCollector<Pair<T, U>, R> groupCollector;
            private final Map<K, GroupCollector<K, T>> keyCollectors = new LinkedHashMap();
            private final Map<GroupCollector<K, T>, GroupCollector<V, U>> valueCollectors = new HashMap();

            public GroupCollectorImpl() {
                this.groupCollector = Mixin.this.mixin.createGroupCollector();
            }

            @Override
            public void add(Pair<K, V> pair) {
                Object first = pair.getFirst();
                GroupCollector<Object, Object> keyCollector = this.keyCollectors.get(first);
                if (keyCollector == null) {
                    keyCollector = Mixin.this.keyExpression.createGroupCollector();
                    this.keyCollectors.put(first, keyCollector);
                }
                keyCollector.add(first);
                GroupCollector<Object, Object> valueCollector = this.valueCollectors.get(keyCollector);
                if (valueCollector == null) {
                    valueCollector = Mixin.this.valueExpression.createGroupCollector();
                    this.valueCollectors.put(keyCollector, valueCollector);
                }
                Object second = pair.getSecond();
                valueCollector.add(second);
            }

            @Override
            public R get() {
                for (GroupCollector keyCollector : this.keyCollectors.values()) {
                    Object key = keyCollector.get();
                    GroupCollector valueCollector = this.valueCollectors.remove(keyCollector);
                    Object value = valueCollector.get();
                    this.groupCollector.add(Pair.of(key, value));
                }
                this.keyCollectors.clear();
                return (Map)this.groupCollector.get();
            }
        }
    }
}

