/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.analysis;

import com.atlassian.rm.jpo.scheduling.roadmap.analysis.BoundDiscreteStepFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.IBoundedDiscreteStepFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.IUnstructuredStageProfile;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.StepFunctionCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.UnstructuredStageProfile;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

class StageProfileCreator {
    private final StepFunctionCreator stepFunctionCreator;

    public StageProfileCreator() {
        this(new StepFunctionCreator());
    }

    StageProfileCreator(StepFunctionCreator stepFunctionCreator) {
        this.stepFunctionCreator = stepFunctionCreator;
    }

    public LinkedHashMap<IProcessingStage, IUnstructuredStageProfile> calculateStageProfiles(IUnstructuredItemSchedule schedule, IProcessingDefinition processingDefinition) {
        Set<IWorkAssignment> workAssignments = schedule.getWorkAssignments();
        IAggregatedWorkPackage workPackage = schedule.getAggregatedWorkPackage();
        List<IProcessingStage> stages = workPackage.getSpecifiedStages();
        LinkedHashMap stageProfiles = Maps.newLinkedHashMap();
        for (IProcessingStage stage : stages) {
            Set<IResourceType> stageTypes = stage.getResourceTypes();
            IBoundedDiscreteStepFunction stageDone = this.stepFunctionCreator.addAmountsOnStart(stageTypes, workAssignments, schedule.getEnd());
            IBoundedDiscreteStepFunction stageEligible = this.createEligibleFunction(schedule, workPackage, stage, processingDefinition.isStageTransitionEnforced());
            UnstructuredStageProfile stageProfile = new UnstructuredStageProfile(stageDone, stageEligible, processingDefinition.getMinLoadPerSprint());
            stageProfiles.put(stage, stageProfile);
        }
        return stageProfiles;
    }

    private IBoundedDiscreteStepFunction createEligibleFunction(IUnstructuredItemSchedule schedule, IAggregatedWorkPackage workPackage, IProcessingStage stage, boolean stageTransitionEnforced) {
        IBoundedDiscreteStepFunction stageEligible;
        Optional<IProcessingStage> previousStage = workPackage.getPreviousStage(stage);
        if (previousStage.isPresent()) {
            Set<IResourceType> prevStageTypes = ((IProcessingStage)previousStage.get()).getResourceTypes();
            stageEligible = stageTransitionEnforced ? this.stepFunctionCreator.addAmountsAfterEnd(prevStageTypes, schedule.getWorkAssignments(), schedule.getEnd()) : this.stepFunctionCreator.addAmountsOnStart(prevStageTypes, schedule.getWorkAssignments(), schedule.getEnd());
            float factor = ((IProcessingStageWorkPackage)workPackage.getWorkPackageForStage(stage).get()).getAmount() / ((IProcessingStageWorkPackage)workPackage.getWorkPackageForStage((IProcessingStage)previousStage.get()).get()).getAmount();
            stageEligible.multiply(factor);
        } else {
            float stageAmount = ((IProcessingStageWorkPackage)workPackage.getWorkPackageForStage(stage).get()).getAmount();
            stageEligible = new BoundDiscreteStepFunction(schedule.getEnd());
            stageEligible.addBetween(schedule.getReleaseTime(), schedule.getEnd(), stageAmount);
        }
        return stageEligible;
    }
}

