/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceCostCalculator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceSupplyStatistics;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IRoadmapProblemStatistics;
import com.atlassian.rm.jpo.scheduling.util.RmSortableUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import java.util.Map;
import java.util.Set;

public class MutableResourceCostCalculator
implements IMutableResourceCostCalculator {
    private static final Log LOGGER = Log.with(MutableResourceCostCalculator.class);

    private static float calculateTypeWeights(IResourceType type, IResourceSupplyStatistics supplyStatistics) {
        Map<IResourceType, Set<IWorkResource>> resourceTypeToResourcesMap = supplyStatistics.getResourceTypeToResourcesMap();
        Set<IWorkResource> resources = resourceTypeToResourcesMap.get(type);
        if (resources == null || resources.isEmpty()) {
            LOGGER.warn("found data inconsistency in cost calculation for type: %s", type.getId());
            return 0.0f;
        }
        return 1.0f / (float)resources.size();
    }

    @Override
    public float calculateWeight(IMutableResource resource, IRoadmapProblemStatistics projectStatistics) {
        IResourceSupplyStatistics supplyStatistics = projectStatistics.getResourceSupplyStatistics();
        float coefficient = 0.0f;
        for (IResourceType type : RmSortableUtils.sort(resource.getTypeSupplies().keySet())) {
            float typeWeight = MutableResourceCostCalculator.calculateTypeWeights(type, supplyStatistics);
            float resourceEfficiency = resource.getTypeSupplies().get(type);
            coefficient += resourceEfficiency * typeWeight;
        }
        return coefficient;
    }

    @Override
    public PrimitivesMap<IMutableResource> getResourceCosts(IRoadmapProblemStatistics projectStatistics, Set<IMutableResource> resources) {
        MutablePrimitivesMap<IMutableResource> costs = RmCollectionUtils.newMutableMap(resources.size());
        for (IMutableResource resource : resources) {
            costs.put(resource, this.calculateWeight(resource, projectStatistics));
        }
        return costs;
    }
}

