/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.teams;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.generator.teams.ITeamConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.ITeamsConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.TeamPersistency;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAbilityPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAbsenceIntervalPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAvailabilityIntervalPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPersonPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPresenceIntervalPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioResourcePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioSprintPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import java.sql.SQLException;
import java.util.List;

public class TeamsPersistency {
    private final TeamPersistency teamPersistence;

    public TeamsPersistency(PortfolioPersonPersistence personPersistence, PortfolioAbilityPersistence abilityPersistence, PortfolioTeamPersistence teamPersistence, PortfolioResourcePersistence resourcePersistence, PortfolioSprintPersistence sprintPersistence, PortfolioAvailabilityIntervalPersistence availabilityIntervalPersistence, PortfolioPresenceIntervalPersistence presenceIntervalPersistence, PortfolioAbsenceIntervalPersistence absenceIntervalPersistence) {
        this.teamPersistence = new TeamPersistency(personPersistence, abilityPersistence, teamPersistence, resourcePersistence, sprintPersistence, availabilityIntervalPersistence, presenceIntervalPersistence, absenceIntervalPersistence);
    }

    public void persist(ITeamsConfiguration configuration, IPlan plan) throws PersistenceException, SQLException {
        List teamConfigurations = Lists.reverse(configuration.getTeamConfigurations());
        for (ITeamConfiguration teamConfiguration : teamConfigurations) {
            this.teamPersistence.persistTeam(teamConfiguration, plan);
        }
    }
}

