/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.extensions.analytics;

import com.radiantminds.roadmap.common.data.entities.releases.SchedulingRelease;
import com.radiantminds.roadmap.common.data.entities.releases.SchedulingStream;
import java.util.List;

class StreamStatistics {
    private final long fixedEndReleaseCount;
    private final long dynamicReleaseCount;

    StreamStatistics(long fixedEndReleaseCount, long dynamicReleaseCount) {
        this.fixedEndReleaseCount = fixedEndReleaseCount;
        this.dynamicReleaseCount = dynamicReleaseCount;
    }

    static StreamStatistics create(List<? extends SchedulingStream> streams) {
        long fixedEndReleaseCount = 0L;
        long dynamicReleaseCount = 0L;
        if (streams != null) {
            for (SchedulingStream schedulingStream : streams) {
                List<? extends SchedulingRelease> releases = schedulingStream.getReleases();
                if (releases == null) continue;
                for (SchedulingRelease schedulingRelease : releases) {
                    if (schedulingRelease.getFixedEndDate() != null && schedulingRelease.getFixedEndDate().isPresent()) {
                        ++fixedEndReleaseCount;
                        continue;
                    }
                    ++dynamicReleaseCount;
                }
            }
        }
        return new StreamStatistics(fixedEndReleaseCount, dynamicReleaseCount);
    }

    long getFixedEndReleaseCount() {
        return this.fixedEndReleaseCount;
    }

    long getDynamicReleaseCount() {
        return this.dynamicReleaseCount;
    }
}

