/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers.sync.workitems;

import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.handlers.sync.workitems.WorkItemSyncConfiguration;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ValidatedWorkItemSyncConfiguration
implements WorkItemSyncConfiguration {
    private final List<String> workItemIds;
    private final boolean syncVersionsDestructively;
    private final boolean assigneeSynced;
    private final boolean dueDateSynced;
    private final boolean estimateSynced;
    private final boolean versionSynced;
    private final boolean summarySynced;
    private final boolean descriptionSynced;
    private final boolean issueLinksSynced;
    private final boolean syncIssueLinksDestructively;
    private final String issueLinkTypeId;

    private ValidatedWorkItemSyncConfiguration(List<String> workItemIds, boolean assigneeSynced, boolean dueDateSynced, boolean estimateSynced, boolean versionSynced, boolean syncVersionsDestructively, boolean summarySynced, boolean descriptionSynced, boolean issueLinksSynced, boolean syncIssueLinksDestructively, String issueLinkTypeId) {
        this.syncVersionsDestructively = syncVersionsDestructively;
        this.summarySynced = summarySynced;
        this.descriptionSynced = descriptionSynced;
        this.workItemIds = Collections.unmodifiableList(workItemIds);
        this.assigneeSynced = assigneeSynced;
        this.dueDateSynced = dueDateSynced;
        this.estimateSynced = estimateSynced;
        this.versionSynced = versionSynced;
        this.issueLinksSynced = issueLinksSynced;
        this.syncIssueLinksDestructively = syncIssueLinksDestructively;
        this.issueLinkTypeId = issueLinkTypeId;
    }

    @Override
    public boolean isAssigneeSynced() {
        return this.assigneeSynced;
    }

    @Override
    public boolean isDueDateSynced() {
        return this.dueDateSynced;
    }

    @Override
    public boolean isEstimateSynced() {
        return this.estimateSynced;
    }

    @Override
    public boolean isVersionSynced() {
        return this.versionSynced;
    }

    @Override
    public boolean syncVersionsDestructively() {
        return this.syncVersionsDestructively;
    }

    @Override
    public List<String> getWorkItemIds() {
        return this.workItemIds;
    }

    @Override
    public boolean isSummarySynced() {
        return this.summarySynced;
    }

    @Override
    public boolean isDescriptionSynced() {
        return this.descriptionSynced;
    }

    @Override
    public boolean areIssueLinksSynced() {
        return this.issueLinksSynced;
    }

    @Override
    public String getIssueLinkTypeId() {
        return this.issueLinkTypeId;
    }

    @Override
    public boolean syncIssueLinksDesctructively() {
        return this.syncIssueLinksDestructively;
    }

    public static Optional<ValidatedWorkItemSyncConfiguration> tryCreate(@Nullable WorkItemSyncConfiguration workItemSyncParameters) {
        if (workItemSyncParameters == null) {
            return Optional.absent();
        }
        List<String> workItemIds = workItemSyncParameters.getWorkItemIds();
        if (workItemIds == null) {
            return Optional.absent();
        }
        boolean assigneeSynced = workItemSyncParameters.isAssigneeSynced();
        boolean dueDateSynced = workItemSyncParameters.isDueDateSynced();
        boolean estimateSynced = workItemSyncParameters.isEstimateSynced();
        boolean versionSynced = workItemSyncParameters.isVersionSynced();
        boolean syncDestruct = workItemSyncParameters.syncVersionsDestructively();
        boolean issueLinksSynced = workItemSyncParameters.areIssueLinksSynced();
        boolean syncIssueLinksDestructively = workItemSyncParameters.syncIssueLinksDesctructively();
        String issueLinkTypeId = workItemSyncParameters.getIssueLinkTypeId();
        if (RmUtils.isAllFalse(assigneeSynced, dueDateSynced, estimateSynced, versionSynced, issueLinksSynced, workItemSyncParameters.isSummarySynced(), workItemSyncParameters.isDescriptionSynced())) {
            return Optional.absent();
        }
        return Optional.of((Object)new ValidatedWorkItemSyncConfiguration(workItemIds, assigneeSynced, dueDateSynced, estimateSynced, versionSynced, syncDestruct, workItemSyncParameters.isSummarySynced(), workItemSyncParameters.isDescriptionSynced(), issueLinksSynced, syncIssueLinksDestructively, issueLinkTypeId));
    }
}

