/*
 * Decompiled with CFR 0.152.
 */
package it.com.radiantminds.plugins.jira;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.rm.common.envtestutils.ProjectDefinition;
import com.atlassian.rm.common.envtestutils.User;
import com.atlassian.rm.common.envtestutils.WiredIntegrationTestClassRule;
import com.atlassian.rm.common.envtestutils.WiredIntegrationTestMethodRule;
import com.atlassian.rm.common.envtestutils.WiredTestCase;
import com.atlassian.rm.common.envtestutils.WiredTestRuleFactory;
import com.atlassian.rm.common.envtestutils.WiredTestUtils;
import com.atlassian.rm.common.envtestutils.annotations.AgileRequirements;
import com.atlassian.rm.common.envtestutils.annotations.Login;
import com.atlassian.rm.common.envtestutils.annotations.Projects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.extensions.projects.ProjectNotFoundException;
import com.radiantminds.roadmap.common.extensions.versions.CreateVersionPermissionException;
import com.radiantminds.roadmap.common.extensions.versions.CreateVersionRequest;
import com.radiantminds.roadmap.common.extensions.versions.ListVersionResult;
import com.radiantminds.roadmap.common.extensions.versions.VersionData;
import com.radiantminds.roadmap.common.extensions.versions.VersionExtension;
import it.com.radiantminds.plugins.jira.testdata.InvisibleToNonAdminProject;
import it.com.radiantminds.plugins.jira.testdata.ReadOnlyToNonAdminProject;
import it.com.radiantminds.plugins.jira.testdata.ScrumProject;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class VersionExtensionTest
extends WiredTestCase {
    @Rule
    public final WiredIntegrationTestMethodRule wiredIntegrationTestRule = WiredTestRuleFactory.methodRule();
    @ClassRule
    public static final WiredIntegrationTestClassRule WIRED_INTEGRATION_TEST_CLASS_RULE = WiredTestRuleFactory.classRule();
    private final VersionExtension versionExtension;
    private final VersionManager versionManager;

    @Autowired
    public VersionExtensionTest(VersionExtension versionExtension, VersionManager versionManager) {
        this.versionExtension = versionExtension;
        this.versionManager = versionManager;
    }

    @Test
    @Login(user=User.ADMIN)
    @AgileRequirements(installed=true)
    @Projects(value={ScrumProject.class})
    public void testCreateVersion() throws Exception {
        final Project scrumProject = this.wiredIntegrationTestRule.getProject(ScrumProject.class);
        CreateVersionRequest request = new CreateVersionRequest(){

            public Long getProjectId() {
                return scrumProject.getId();
            }

            public String getName() {
                return "Foo";
            }

            public String getDescription() {
                return "Desc";
            }

            public Long getStartDateUTC() {
                return null;
            }

            public Long getEndDateUTC() {
                return null;
            }
        };
        Long versionId = this.versionExtension.createVersion(request);
        Version persisted = this.versionManager.getVersion(versionId);
        Assert.assertEquals((Object)"Foo", (Object)persisted.getName());
        Assert.assertEquals((Object)"Desc", (Object)persisted.getDescription());
        Assert.assertEquals((Object)scrumProject.getId(), (Object)persisted.getProjectId());
    }

    @Test(expected=CreateVersionPermissionException.class)
    @Login(user=User.NON_ADMIN)
    @AgileRequirements(installed=true)
    @Projects(value={ScrumProject.class})
    public void testCreateVersionNoPermission() throws Exception {
        final Project scrumProject = this.wiredIntegrationTestRule.getProject(ScrumProject.class);
        CreateVersionRequest request = new CreateVersionRequest(){

            public Long getProjectId() {
                return scrumProject.getId();
            }

            public String getName() {
                return "Foo";
            }

            public String getDescription() {
                return "Desc";
            }

            public Long getStartDateUTC() {
                return null;
            }

            public Long getEndDateUTC() {
                return null;
            }
        };
        this.versionExtension.createVersion(request);
    }

    @Test(expected=ProjectNotFoundException.class)
    @Login(user=User.NON_ADMIN)
    public void testCreateVersionNoProject() throws Exception {
        long nonExistentId = 999999L;
        CreateVersionRequest request = new CreateVersionRequest(){

            public Long getProjectId() {
                return 999999L;
            }

            public String getName() {
                return "Foo";
            }

            public String getDescription() {
                return "Desc";
            }

            public Long getStartDateUTC() {
                return null;
            }

            public Long getEndDateUTC() {
                return null;
            }
        };
        this.versionExtension.createVersion(request);
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={VersionExtensionTestProjectDefinition.class})
    public void testExcluded() throws Exception {
        Project project = this.wiredIntegrationTestRule.getProject(VersionExtensionTestProjectDefinition.class);
        ArrayList created = Lists.newArrayList();
        for (int i = 0; i < 45; ++i) {
            Version version = this.versionManager.createVersion("Version " + i, null, "Foo", project.getId(), null);
            created.add(version);
        }
        ListVersionResult versions = this.versionExtension.findVersions(project.getId(), null, (Set)Sets.newHashSet((Object[])new Long[]{((Version)created.get(17)).getId(), ((Version)created.get(21)).getId(), ((Version)created.get(42)).getId()}), Integer.valueOf(100));
        Assert.assertEquals((long)42L, (long)versions.getVersions().size());
        Assert.assertFalse((boolean)versions.isMoreAvailable());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={VersionExtensionTestProjectDefinition.class})
    public void testBaseRetrieval() throws Exception {
        Project project = this.wiredIntegrationTestRule.getProject(VersionExtensionTestProjectDefinition.class);
        Version originalVersion = this.versionManager.createVersion("Name", new Date(0L), new Date(1L), "Description", project.getId(), null);
        ListVersionResult versions = this.versionExtension.findVersions(project.getId(), null, null, Integer.valueOf(100));
        Assert.assertEquals((long)1L, (long)versions.getVersions().size());
        Assert.assertFalse((boolean)versions.isMoreAvailable());
        VersionData version = (VersionData)versions.getVersions().get(0);
        Assert.assertEquals((Object)originalVersion.getId(), (Object)version.getId());
        Assert.assertEquals((Object)"Name", (Object)version.getName());
        Assert.assertEquals((Object)"Description", (Object)version.getDescription());
        Assert.assertEquals((Object)new Date(0L), (Object)version.getStartDate());
        Assert.assertEquals((Object)new Date(1L), (Object)version.getReleaseDate());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={VersionExtensionTestProjectDefinition.class})
    public void testLimitNoSearchTerm() throws Exception {
        Project project = this.wiredIntegrationTestRule.getProject(VersionExtensionTestProjectDefinition.class);
        for (int i = 0; i < 51; ++i) {
            this.versionManager.createVersion("Version " + i, null, "Foo", project.getId(), null);
        }
        ListVersionResult versions = this.versionExtension.findVersions(project.getId(), null, null, Integer.valueOf(50));
        Assert.assertEquals((long)50L, (long)versions.getVersions().size());
        Assert.assertTrue((boolean)versions.isMoreAvailable());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={VersionExtensionTestProjectDefinition.class})
    public void testLimitWithSearchTerm() throws Exception {
        Project project = this.wiredIntegrationTestRule.getProject(VersionExtensionTestProjectDefinition.class);
        for (int i = 0; i < 51; ++i) {
            this.versionManager.createVersion("Version " + i, null, "Foo", project.getId(), null);
        }
        ListVersionResult versions = this.versionExtension.findVersions(project.getId(), "Version", null, Integer.valueOf(50));
        Assert.assertEquals((long)50L, (long)versions.getVersions().size());
        Assert.assertTrue((boolean)versions.isMoreAvailable());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={VersionExtensionTestProjectDefinition.class})
    public void testSearchTerm() throws Exception {
        Project project = this.wiredIntegrationTestRule.getProject(VersionExtensionTestProjectDefinition.class);
        this.versionManager.createVersion("foo", null, "bar", project.getId(), null);
        this.versionManager.createVersion("bar", null, "foo", project.getId(), null);
        this.versionManager.createVersion("bang", null, "bang", project.getId(), null);
        ListVersionResult versions = this.versionExtension.findVersions(project.getId(), "foo", null, Integer.valueOf(100));
        Assert.assertEquals((long)1L, (long)versions.getVersions().size());
        Assert.assertFalse((boolean)versions.isMoreAvailable());
    }

    @Test
    @Login(user=User.ADMIN)
    @Projects(value={VersionExtensionTestProjectDefinition.class})
    public void testNonExistingRetrieval() {
        long nonExistentId = 999999L;
        ListVersionResult versions = this.versionExtension.findVersions(Long.valueOf(999999L), null, null, Integer.valueOf(100));
        Assert.assertEquals((long)0L, (long)versions.getVersions().size());
    }

    @Test
    @Login(user=User.NON_ADMIN)
    @Projects(value={ReadOnlyToNonAdminProject.class})
    public void testReadOnlyAccessRetrieval() {
        Project readOnlyToNonAdminProject = this.wiredIntegrationTestRule.getProject(ReadOnlyToNonAdminProject.class);
        ListVersionResult versions = this.versionExtension.findVersions(readOnlyToNonAdminProject.getId(), null, null, Integer.valueOf(100));
        Assert.assertEquals((long)readOnlyToNonAdminProject.getVersions().size(), (long)versions.getVersions().size());
    }

    @Test
    @Login(user=User.NON_ADMIN)
    @AgileRequirements(installed=true)
    @Projects(value={InvisibleToNonAdminProject.class})
    public void testInvisibleAccessRetrieval() {
        Project invisibleToNonAdminProject = this.wiredIntegrationTestRule.getProject(InvisibleToNonAdminProject.class);
        ListVersionResult versions = this.versionExtension.findVersions(invisibleToNonAdminProject.getId(), null, null, Integer.valueOf(100));
        Assert.assertEquals((long)0L, (long)versions.getVersions().size());
    }

    @Test
    @Login(user=User.ADMIN)
    @AgileRequirements(installed=true)
    @Projects(value={InvisibleToNonAdminProject.class})
    public void testInvisibleAccessRetrievalForAdmin() {
        Project invisibleToNonAdminProject = this.wiredIntegrationTestRule.getProject(InvisibleToNonAdminProject.class);
        ListVersionResult versions = this.versionExtension.findVersions(invisibleToNonAdminProject.getId(), null, null, Integer.valueOf(100));
        Assert.assertEquals((long)invisibleToNonAdminProject.getVersions().size(), (long)versions.getVersions().size());
    }

    private static class VersionExtensionTestProjectDefinition
    implements ProjectDefinition {
        private static final String PROJECT_KEY = "VETPD";

        private VersionExtensionTestProjectDefinition() {
        }

        public Project instantiate(WiredTestUtils utils) throws Exception {
            return utils.getProjectUtils().createStandardProject(utils.getUserUtils().getAdminUser(), PROJECT_KEY, PROJECT_KEY);
        }
    }
}

