/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.handlers.workitems.link;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemExtensionLinkData;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressConfiguration;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressData;
import com.radiantminds.roadmap.common.extensions.workitems.StatusData;
import com.radiantminds.roadmap.common.extensions.workitems.WorkData;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.handlers.extensionlinks.AddExtensionLinkRequest;
import com.radiantminds.roadmap.common.handlers.extensionlinks.BaseExtensionLinkHandler;
import com.radiantminds.roadmap.common.handlers.extensionlinks.InvalidLinkException;
import com.radiantminds.roadmap.common.handlers.extensionlinks.SecureExtensionLinkHandler;
import com.radiantminds.roadmap.common.rest.entities.progress.RestProgressConfiguration;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestProgress;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestStatusInfo;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestWorkInfo;
import com.radiantminds.roadmap.common.rest.entities.workitems.links.RestWorkItemExtensionLinkResponse;
import com.radiantminds.roadmap.common.rest.entities.workitems.links.RestWorkItemExtensionLinks;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WorkItemExtensionLinkHandler
extends BaseExtensionLinkHandler<IWorkItem, PortfolioWorkItemPersistence> {
    private static final Log LOGGER = Log.with(WorkItemExtensionLinkHandler.class);
    public static Pattern JIRA_LINK_PATTERN = Pattern.compile("^(.+)-\\d+");
    public static final String JIRA_ISSUE_PREFIX = "jira-issue";
    private static final String JIRA_ISSUE_STAGE_PREFIX = "jira-issue-stage";
    private final PortfolioPlanPersistence planPersistence;
    private final WorkItemExtension workItemExtension;

    WorkItemExtensionLinkHandler(PortfolioWorkItemPersistence workItemPersistence, PortfolioPlanPersistence planPersistence, PortfolioExtensionLinkPersistence extensionLinkPersistence, WorkItemExtension workItemExtension) {
        super(workItemPersistence, extensionLinkPersistence);
        this.planPersistence = planPersistence;
        this.workItemExtension = workItemExtension;
    }

    @Override
    protected void onBeforeAdd(String id, AddExtensionLinkRequest request, Class<IWorkItem> entityClazz) throws InvalidLinkException, SQLException {
        String key = request.getKey();
        if (key.startsWith(JIRA_ISSUE_PREFIX)) {
            Matcher matcher = JIRA_LINK_PATTERN.matcher(request.getLink());
            if (!matcher.matches()) {
                throw new InvalidLinkException();
            }
            String projectPrefix = matcher.group(1) + "-";
            if (entityClazz == IWorkItem.class) {
                if (WorkItems.Types.STORY.equals(((PortfolioWorkItemPersistence)this.persistence).getWorkItemType(id))) {
                    if (key.startsWith(JIRA_ISSUE_STAGE_PREFIX)) {
                        this.extensionLinkPersistence.removeAllExtensionLinksWhereKeyLike(AOWorkItem.class, id, JIRA_ISSUE_PREFIX, JIRA_ISSUE_STAGE_PREFIX);
                        this.extensionLinkPersistence.removeAllExtensionLinksWhereKeyLike(AOWorkItem.class, id, key, new String[0]);
                    } else if (key.startsWith(JIRA_ISSUE_PREFIX)) {
                        this.extensionLinkPersistence.removeAllExtensionLinksWhereKeyLike(AOWorkItem.class, id, JIRA_ISSUE_PREFIX, new String[0]);
                    }
                } else {
                    if (key.startsWith(JIRA_ISSUE_STAGE_PREFIX)) {
                        throw new InvalidLinkException();
                    }
                    if (key.startsWith(JIRA_ISSUE_PREFIX)) {
                        this.extensionLinkPersistence.removeAllExtensionLinksWhereValueStartsWith(AOWorkItem.class, id, JIRA_ISSUE_PREFIX, projectPrefix);
                    }
                }
            }
        }
    }

    @Override
    protected Object generateResponseEntity(EntityContext<IWorkItem> entityContext, Collection<AddExtensionLinkRequest> links) throws Exception {
        ProgressConfiguration config = this.getProgressConfigurationFromContext(entityContext);
        ArrayList enrichedLinks = Lists.newArrayList();
        for (AddExtensionLinkRequest link : links) {
            ProgressConfiguration configurationToUse = link.getProgressConfiguration() != null ? link.getProgressConfiguration() : config;
            enrichedLinks.add(this.createEnrichedLink(link, configurationToUse));
        }
        return new RestWorkItemExtensionLinks(enrichedLinks);
    }

    public static SecureExtensionLinkHandler<IWorkItem> createSecureWorkItemExtensionLinkService(SecuredInvocationHandlerFactory handlerFactory, PortfolioPlanPersistence planPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioExtensionLinkPersistence extensionLinkPersistence, WorkItemExtension workItemExtension) {
        LOGGER.debug("create new instance", new Object[0]);
        return handlerFactory.createProxy(SecureExtensionLinkHandler.class, new WorkItemExtensionLinkHandler(workItemPersistence, planPersistence, extensionLinkPersistence, workItemExtension), workItemPersistence);
    }

    private ProgressConfiguration getProgressConfigurationFromContext(EntityContext<IWorkItem> context) throws SQLException {
        IPlanConfiguration config = this.planPersistence.getPlanConfiguration(context.getEntityInfo().getPlanId());
        return RestProgressConfiguration.from(config);
    }

    private RestWorkItemExtensionLinkResponse createEnrichedLink(AddExtensionLinkRequest addRequest, ProgressConfiguration progressConfiguration) throws Exception {
        String linkKey = addRequest.getKey();
        String issueKey = addRequest.getLink();
        RestWorkItemExtensionLinkResponse retVal = new RestWorkItemExtensionLinkResponse(linkKey, issueKey);
        if (progressConfiguration != null) {
            WorkItemExtensionLinkData extensionLinkData = this.workItemExtension.getExtensionLinkData(progressConfiguration, Sets.newHashSet((Object[])new String[]{issueKey})).getResult();
            StatusData statusData = extensionLinkData.getStatusData(issueKey);
            if (statusData != null) {
                ProgressData selfProgress;
                retVal.setStatusInfo(RestStatusInfo.from(statusData));
                ProgressData fullProgress = extensionLinkData.getFullProgress(issueKey);
                if (fullProgress != null) {
                    retVal.setFullProgress(RestProgress.from(fullProgress));
                }
                if ((selfProgress = extensionLinkData.getProgress(issueKey)) != null) {
                    retVal.setSelfProgress(RestProgress.from(selfProgress));
                }
            }
            retVal.setEstimationRatio(extensionLinkData.getEstimatedRationData(issueKey));
            WorkData timeData = extensionLinkData.getTimeData(issueKey);
            if (timeData != null) {
                retVal.setSelfWorkInfo(RestWorkInfo.createSelfWorkInfoFrom(timeData));
                retVal.setFullWorkInfo(RestWorkInfo.createFullWorkInfoFrom(timeData));
            }
        }
        return retVal;
    }
}

