/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.stats;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IEpisodeStatistics;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class EpisodeStatistics
implements IEpisodeStatistics {
    private final String id;
    private final double avgResourceUtilization;
    private final double workLoad;
    private final double availableWork;
    private final PositivePrimitivesMap<IResourceType> freeCapacitiesOfResourceTypes;
    private final Double overbookedWork;
    private final IIntegerInterval interval;

    public EpisodeStatistics(String id, double avgResourceUtilization, double workLoad, double availableWork, PositivePrimitivesMap<IResourceType> freeCapacitiesOfResourceTypes, Double overbookedWork, IIntegerInterval interval) {
        this.id = id;
        this.avgResourceUtilization = avgResourceUtilization;
        this.workLoad = workLoad;
        this.availableWork = availableWork;
        this.freeCapacitiesOfResourceTypes = freeCapacitiesOfResourceTypes;
        this.overbookedWork = overbookedWork;
        this.interval = interval;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public double getAvgResourceUtilization() {
        return this.avgResourceUtilization;
    }

    @Override
    public double getWorkLoad() {
        return this.workLoad;
    }

    @Override
    public List<IResourceType> getFreeCapacitiesOfResourceTypes() {
        return RmUtils.getReverseOrderWithNumericalValues(this.freeCapacitiesOfResourceTypes);
    }

    @Override
    public Optional<Double> getOverBookedWork() {
        return Optional.fromNullable((Object)this.overbookedWork);
    }

    @Override
    public PositivePrimitivesMap<IResourceType> getFreeTypes() {
        return this.freeCapacitiesOfResourceTypes;
    }

    @Override
    public int getStart() {
        return this.interval.getStart();
    }

    @Override
    public int getEnd() {
        return this.interval.getEnd();
    }

    @Override
    public int getLength() {
        return this.interval.getLength();
    }

    @Override
    public boolean contains(int value) {
        return this.interval.contains(value);
    }

    @Override
    public Optional<IIntegerInterval> getOverlappingInterval(IIntegerInterval interval) {
        return this.interval.getOverlappingInterval(interval);
    }

    @Override
    public double getAvailableWork() {
        return this.availableWork;
    }
}

