/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.scheduling;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.dep.IDependencyDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IBacklog;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.people.IterationStartType;
import com.radiantminds.roadmap.common.data.entities.people.PlanningMode;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingInterval;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingPerson;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingResource;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlanUtil;
import com.radiantminds.roadmap.common.data.entities.skills.SchedulingSkill;
import com.radiantminds.roadmap.common.data.entities.skills.SchedulingStage;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.rest.entities.plans.RestWeekdayConfiguration;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestDependencyInformation;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestHierarchyInformation;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestItemPrerequisites;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestParentEntry;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestResourceEntry;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingAssignment;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingSolution;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingSolutionSprintFactory;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSolutionInterval;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSprintSolution;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestStageEntry;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestStreamEntry;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestTeamEntry;
import com.radiantminds.roadmap.common.rest.entities.scheduling.annotations.RestSchedulingAnnotation;
import com.radiantminds.roadmap.common.rest.entities.scheduling.annotations.RestSchedulingSolutionAnnotationFactory;
import com.radiantminds.roadmap.common.rest.entities.scheduling.cap.RestPlanCapacity;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IPlanSolution;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class RestSchedulingSolutionFactory {
    public static RestSchedulingSolution create(SchedulingPlan plan, IPlanSolution planSolution, @Nullable IRoadmapProblem roadmapProblem) {
        SchedulingPlanUtil planUtil = new SchedulingPlanUtil(plan);
        List<RestSchedulingAssignment> assignments = RestSchedulingSolutionFactory.createAssignments(plan, planUtil, planSolution);
        List<RestTeamEntry> teams = RestSchedulingSolutionFactory.createTeams(plan);
        List<RestStreamEntry> streams = RestSchedulingSolutionFactory.createStreams(plan, planSolution);
        List<RestStageEntry> stages = RestSchedulingSolutionFactory.createStages(plan);
        List<RestSprintSolution> sprints = RestSchedulingSolutionFactory.createSprints(plan, planSolution);
        List<RestSchedulingAnnotation> annotations = RestSchedulingSolutionAnnotationFactory.createAnnotations(plan, planSolution.getScheduleAnnotations().getViolations(), planSolution.getScheduleAnnotations().getWarnings());
        RestDependencyInformation dependencyInformation = (RestDependencyInformation)RestSchedulingSolutionFactory.createDependencyInformation(roadmapProblem).orNull();
        RestHierarchyInformation hierarchyInformation = RestSchedulingSolutionFactory.createHierarchyInformation(plan.getWorkItems());
        return new RestSchedulingSolution(planSolution.getSchedulingVersion(), (Long)plan.getDate().orNull(), planSolution.getPlanStartTimestamp(), plan.getPlanConfiguration(), assignments, teams, streams, stages, sprints, annotations, dependencyInformation, hierarchyInformation, RestSchedulingSolutionFactory.createRestIntervals(plan.getNonWorkingDays()), RestWeekdayConfiguration.fromWeekdayConfiguration(plan.getPlanConfiguration().getWeekdayConfiguration()), RestPlanCapacity.create(planSolution.getCapacityData()));
    }

    private static List<RestSolutionInterval> createRestIntervals(List<? extends SchedulingInterval> nonWorkingDays) {
        ArrayList restIntervals = Lists.newArrayList();
        for (SchedulingInterval schedulingInterval : nonWorkingDays) {
            restIntervals.add(RestSolutionInterval.create(schedulingInterval));
        }
        return restIntervals;
    }

    static RestHierarchyInformation createHierarchyInformation(List<? extends SchedulingWorkItem> workItems) {
        ArrayList parentEntries = Lists.newArrayList();
        for (SchedulingWorkItem schedulingWorkItem : workItems) {
            String parentId = schedulingWorkItem.getParentId();
            if (parentId == null) continue;
            parentEntries.add(new RestParentEntry(schedulingWorkItem.getId(), parentId));
        }
        return new RestHierarchyInformation(parentEntries);
    }

    static Optional<RestDependencyInformation> createDependencyInformation(@Nullable IRoadmapProblem roadmapProblem) {
        if (roadmapProblem == null) {
            return Optional.absent();
        }
        ArrayList prerequisitesList = Lists.newArrayList();
        IBacklog backlog = roadmapProblem.getBacklog();
        IDependencyDefinition dependencyDefinition = backlog.getDependencyDefinition();
        for (IProcessingItem item : backlog.getProcessingItems()) {
            Set<IProcessingItem> directPrerequisites = dependencyDefinition.getDirectPrerequisites(item);
            if (directPrerequisites.isEmpty()) continue;
            ArrayList prerequisiteIds = Lists.newArrayList(RmIdentifiableUtils.getIds(directPrerequisites));
            RestItemPrerequisites prerequisitesEntry = new RestItemPrerequisites(item.getId(), prerequisiteIds);
            prerequisitesList.add(prerequisitesEntry);
        }
        RestDependencyInformation restDependencyDefinition = new RestDependencyInformation(prerequisitesList);
        return Optional.of((Object)restDependencyDefinition);
    }

    private static List<RestSchedulingAssignment> createAssignments(SchedulingPlan plan, SchedulingPlanUtil planUtil, IPlanSolution solution) {
        HashMap epicsPerStory = Maps.newHashMap();
        for (Map.Entry<String, SchedulingWorkItem> entry : planUtil.getWorkItemsByType(WorkItems.Types.STORY).entrySet()) {
            if (entry.getValue().getParentId() == null) continue;
            epicsPerStory.put(entry.getKey(), ((SchedulingWorkItem)entry.getValue()).getParentId());
        }
        HashMap initiativesPerEpic = Maps.newHashMap();
        for (Map.Entry entry : planUtil.getWorkItemsByType(WorkItems.Types.EPIC).entrySet()) {
            SchedulingWorkItem schedulingWorkItem = (SchedulingWorkItem)entry.getValue();
            initiativesPerEpic.put(entry.getKey(), schedulingWorkItem.getParentId() != null ? schedulingWorkItem.getParentId() : "-1");
        }
        HashMap stagesPerSkill = Maps.newHashMap();
        for (SchedulingStage schedulingStage : plan.getStages()) {
            stagesPerSkill.put("stageSkill-" + schedulingStage.getId(), schedulingStage.getId());
            for (SchedulingSkill schedulingSkill : schedulingStage.getSkills()) {
                stagesPerSkill.put(schedulingSkill.getId(), schedulingStage.getId());
            }
        }
        return Lists.newArrayList((Iterable)Iterables.transform(solution.getSchedulingAssignments(), RestSchedulingAssignment.createFunction(initiativesPerEpic, epicsPerStory, stagesPerSkill)));
    }

    private static List<RestTeamEntry> createTeams(SchedulingPlan plan) {
        ArrayList retVal = Lists.newArrayList();
        for (SchedulingTeam schedulingTeam : plan.getTeams()) {
            IterationStartType iterationStartType;
            Integer weeksPerSprint = schedulingTeam.getWeeksPerSprint();
            if (weeksPerSprint == null) {
                weeksPerSprint = plan.getPlanConfiguration().getGlobalSprintLength();
            }
            if ((iterationStartType = schedulingTeam.getIterationStartType()) == null) {
                iterationStartType = IterationStartType.WithReleaseStartDate;
            }
            ArrayList resources = Lists.newArrayList();
            if (!schedulingTeam.getResources().isEmpty()) {
                for (SchedulingResource schedulingResource : schedulingTeam.getResources()) {
                    resources.add(new RestResourceEntry(schedulingResource.getId(), schedulingResource, (SchedulingPerson)plan.getPerson(schedulingResource.getPersonId()).get()));
                }
            }
            retVal.add(new RestTeamEntry(schedulingTeam.getId(), null, schedulingTeam.getPlanningMode().toString(), weeksPerSprint, iterationStartType, resources));
        }
        return retVal;
    }

    private static List<RestStreamEntry> createStreams(SchedulingPlan plan, IPlanSolution planSolution) {
        return Lists.newArrayList((Iterable)Iterables.transform(plan.getStreams(), RestStreamEntry.createFromFunction(planSolution)));
    }

    private static List<RestStageEntry> createStages(SchedulingPlan plan) {
        ArrayList stages = Lists.newArrayList();
        for (SchedulingStage schedulingStage : plan.getStages()) {
            stages.add(new RestStageEntry(schedulingStage));
        }
        return stages;
    }

    private static List<RestSprintSolution> createSprints(SchedulingPlan plan, IPlanSolution planSolution) {
        ArrayList retVal = Lists.newArrayList();
        for (SchedulingTeam schedulingTeam : plan.getTeams()) {
            if (schedulingTeam.getPlanningMode() != PlanningMode.Scrum) continue;
            retVal.addAll(RestSchedulingSolutionSprintFactory.createSprintsForTeam(schedulingTeam.getId(), planSolution));
        }
        return retVal;
    }
}

