/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling;

import com.atlassian.pocketknife.api.logging.Log;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.extensions.analytics.CalculationAnalytics;
import com.radiantminds.roadmap.common.extensions.analytics.PlanProperties;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingSolution;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingSolutionFactory;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSolutionState;
import com.radiantminds.roadmap.common.rest.exceptions.ServerInfoProvider;
import com.radiantminds.roadmap.common.scheduling.CalculationExecutor;
import com.radiantminds.roadmap.common.scheduling.CalculationListener;
import com.radiantminds.roadmap.common.scheduling.CalculationProcess;
import com.radiantminds.roadmap.common.scheduling.CalculationProcessProvider;
import com.radiantminds.roadmap.common.scheduling.CalculationResult;
import com.radiantminds.roadmap.common.scheduling.CalculationState;
import com.radiantminds.roadmap.common.scheduling.CalculationVitalityHandler;
import com.radiantminds.roadmap.common.scheduling.EmptyPlanSolution;
import com.radiantminds.roadmap.common.scheduling.ISolutionCallback;
import com.radiantminds.roadmap.common.scheduling.Threading;
import com.radiantminds.roadmap.common.scheduling.trafo.NoEstimatedWorkItemsDefinedException;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class Calculation {
    private static final Log LOGGER = Log.with(Calculation.class);
    private final Object lock = new Object();
    private final String calculationId;
    private final CalculationExecutor calculationExecutor;
    private final CalculationProcessProvider calculationProcessProvider;
    private final CalculationAnalytics analytics;
    private final SchedulingPlan plan;
    private final CalculationVitalityHandler vitalityHandler;
    private Future<?> future;
    protected RestSchedulingSolution transferableSolution;
    private Exception error;
    private boolean cancelled;

    public Calculation(CalculationExecutor calculationExecutor, CalculationProcessProvider calculationProcessProvider, CalculationVitalityHandler vitalityHandler, CalculationAnalytics analytics, SchedulingPlan plan) {
        this(UUID.randomUUID().toString(), calculationExecutor, calculationProcessProvider, vitalityHandler, analytics, plan);
    }

    public Calculation(String calculationId, CalculationExecutor calculationExecutor, CalculationProcessProvider calculationProcessProvider, CalculationVitalityHandler vitalityHandler, CalculationAnalytics analytics, SchedulingPlan plan) {
        this.calculationId = calculationId;
        this.calculationExecutor = calculationExecutor;
        this.calculationProcessProvider = calculationProcessProvider;
        this.analytics = analytics;
        this.plan = plan;
        this.vitalityHandler = vitalityHandler;
    }

    public CountDownLatch calculate() {
        return this.calculate(new CalculationListener(){

            @Override
            public void completedWithResult(String planId, RestSchedulingSolution solution) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountDownLatch calculate(final CalculationListener calculationListener) {
        if (this.transferableSolution != null) {
            LOGGER.warn("Calculate has been triggered on a complete calculation. Ignoring.", new Object[0]);
            return new CountDownLatch(0);
        }
        this.analytics.publishCalculationStarted(this.calculationId, this.calculationProcessProvider.getMode().toString(), PlanProperties.createFromPlan(this.plan));
        final Long t1 = System.currentTimeMillis();
        final CountDownLatch latch = new CountDownLatch(1);
        Object object = this.lock;
        synchronized (object) {
            if (this.future != null) {
                throw new IllegalStateException("Calculation has already been started.");
            }
            LOGGER.info("[calculation]\tStarting solution calculation...", new Object[0]);
            ExecutorService executorService = this.calculationExecutor.get();
            final CalculationProcess calculationProcess = this.calculationProcessProvider.create(this.plan, this.calculationId, this.vitalityHandler);
            this.future = executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Long t2 = System.currentTimeMillis();
                        CalculationResult result = calculationProcess.execute();
                        Object object = Calculation.this.lock;
                        synchronized (object) {
                            Threading.testInterrupted();
                            Calculation.this.transferableSolution = result.getResult();
                        }
                        calculationListener.completedWithResult(Calculation.this.plan.getId(), Calculation.this.transferableSolution);
                        Calculation.this.analytics.publishCalculationFinished(Calculation.this.calculationId, Calculation.this.calculationProcessProvider.getMode().toString(), PlanProperties.createFromPlan(Calculation.this.plan), Calculation.this.transferableSolution.getLength(), System.currentTimeMillis() - t1, Long.valueOf(Calculation.this.transferableSolution.getAssignments().size()));
                        LOGGER.info("[calculation]\tCreate solver:\t" + result.getSolverCreationTime() + "ms", new Object[0]);
                        LOGGER.info("[calculation]\tSolve:\t\t" + result.getSolveTime() + "ms", new Object[0]);
                        LOGGER.info("[calculation]\tCalculate:\t" + (System.currentTimeMillis() - t2) + "ms", new Object[0]);
                        LOGGER.info("[calculation]\tTotal:\t\t" + (System.currentTimeMillis() - t1) + "ms", new Object[0]);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.info("Calculation cancelled.", new Object[0]);
                    }
                    catch (NoEstimatedWorkItemsDefinedException ex) {
                        LOGGER.info("NoEstimatedWorkItemsDefinedException; trying to get lock to store empty solution...", new Object[0]);
                        Object object = Calculation.this.lock;
                        synchronized (object) {
                            LOGGER.info("Got lock, plan solution is now empty", new Object[0]);
                            Calculation.this.transferableSolution = RestSchedulingSolutionFactory.create(Calculation.this.plan, new EmptyPlanSolution(Calculation.this.plan), null);
                        }
                        calculationListener.completedWithResult(Calculation.this.plan.getId(), Calculation.this.transferableSolution);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Caught exception in scheduling algorithm.", new Object[0]);
                        LOGGER.exception(ex, Log.LogLevel.ERROR);
                        Object object = Calculation.this.lock;
                        synchronized (object) {
                            Calculation.this.error = ex;
                        }
                    }
                    latch.countDown();
                }
            });
        }
        return latch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CalculationState cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.transferableSolution != null) {
                return CalculationState.DONE;
            }
            if (this.future == null) {
                throw new IllegalStateException("Calculation has not yet been started.");
            }
            if (!this.future.isDone()) {
                try {
                    this.analytics.publishCalculationCancelled(this.calculationId, this.calculationProcessProvider.getMode().toString(), PlanProperties.createFromPlan(this.plan));
                }
                catch (Throwable t) {
                    LOGGER.error("Failed to publish calculation cancelled event.", new Object[0]);
                    LOGGER.exception(t, Log.LogLevel.ERROR);
                }
                this.future.cancel(true);
            }
            return CalculationState.CANCELLED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled() {
        Object object = this.lock;
        synchronized (object) {
            return CalculationState.CANCELLED == this.getSolutionState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withCalculationLock(Optional<ServerInfoProvider> serverInfoProvider, ISolutionCallback<T> execution) {
        Object object = this.lock;
        synchronized (object) {
            return execution.execute(this.getState(serverInfoProvider), this.getTransferableSolution());
        }
    }

    public Long getSchedulingVersion() {
        return this.plan.getSchedulingVersion();
    }

    public RestSchedulingSolution getTransferableSolution() {
        return this.transferableSolution;
    }

    private RestSolutionState getState(Optional<ServerInfoProvider> serverInfoProvider) {
        RestSolutionState state;
        CalculationState calculationState = this.getSolutionState();
        if (calculationState == CalculationState.ERROR) {
            String errorString = this.error != null ? (this.error.getMessage() != null ? this.error.getMessage() : this.error.getClass().getSimpleName()) : "Unknown error";
            state = new RestSolutionState(serverInfoProvider, this.getSchedulingVersion(), calculationState, errorString, this.error);
        } else {
            state = new RestSolutionState(this.getSchedulingVersion(), calculationState);
        }
        return state;
    }

    private CalculationState getSolutionState() {
        if (this.transferableSolution != null) {
            return CalculationState.DONE;
        }
        if (this.error != null) {
            return CalculationState.ERROR;
        }
        if (this.future != null) {
            if (!this.future.isDone()) {
                return CalculationState.IN_PROGRESS;
            }
            return CalculationState.CANCELLED;
        }
        return CalculationState.UNKNOWN;
    }

    public String getCalculationId() {
        return this.calculationId;
    }

    public Future<?> getFuture() {
        return this.future;
    }
}

