/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.people.IPerson;
import com.radiantminds.roadmap.common.extensions.usermanagement.UserManagementExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraUserManagementExtension
implements UserManagementExtension {
    static final String JIRA_ID_PREFIX = "JIRA-";
    private final UserManager userManager;

    @Autowired
    public JiraUserManagementExtension(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    public boolean isUserManagementFor(String externalIdentifier) {
        return externalIdentifier.startsWith(JIRA_ID_PREFIX);
    }

    @Override
    public boolean exists(String externalIdentifier) {
        return this.userManager.getUserByKey(JiraUserManagementExtension.getJiraId(externalIdentifier)) != null;
    }

    @Override
    public void enrich(IPerson person) {
        ApplicationUser user = this.userManager.getUserByKey(JiraUserManagementExtension.getJiraId(person.getExternalId()));
        person.setTitle(user.getDisplayName());
        person.setDetails(user.getName());
    }

    @Override
    public Optional<String> getUserName(String externalIdentifier) {
        ApplicationUser user = this.userManager.getUserByKey(JiraUserManagementExtension.getJiraId(externalIdentifier));
        if (user != null) {
            return Optional.fromNullable((Object)user.getName());
        }
        return Optional.absent();
    }

    private static String getJiraId(String externalId) {
        return externalId.substring(JIRA_ID_PREFIX.length());
    }

    private static String getJiraId(Optional<String> externalId) {
        if (externalId.isPresent()) {
            return JiraUserManagementExtension.getJiraId((String)externalId.get());
        }
        return null;
    }
}

