/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.gdpr;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.key.UserKeyChangeHandlerModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import java.util.Collection;
import java.util.stream.Collectors;

class UserKeyChangeBridgeUtility {
    UserKeyChangeBridgeUtility() {
    }

    public static long getNumberOfAffectedEntities(PluginAccessor pluginAccessor, String handlerKey, String originalUserKey, String targetUserKey) {
        return pluginAccessor.getEnabledModuleDescriptorsByClass(UserKeyChangeHandlerModuleDescriptor.class).stream().filter(descriptor -> handlerKey.equals(descriptor.getKey())).map(AbstractJiraModuleDescriptor::getModule).map(handler -> handler.getAffectedEntities((Object)new UserPropertyChangeParameter(originalUserKey, targetUserKey, Contexts.nullContext()))).flatMap(Collection::stream).mapToLong(entity -> entity.getNumberOfOccurrences().orElse(0L)).sum();
    }

    public static Collection<String> getHandlerKeys(PluginAccessor pluginAccessor) {
        return pluginAccessor.getEnabledModuleDescriptorsByClass(UserKeyChangeHandlerModuleDescriptor.class).stream().map(AbstractModuleDescriptor::getKey).collect(Collectors.toSet());
    }

    public static void update(PluginAccessor pluginAccessor, String handlerKey, String originalUserKey, String targetUserKey) throws Exception {
        pluginAccessor.getEnabledModuleDescriptorsByClass(UserKeyChangeHandlerModuleDescriptor.class).stream().filter(descriptor -> handlerKey.equals(descriptor.getKey())).map(AbstractJiraModuleDescriptor::getModule).map(handler -> handler.update((Object)new UserPropertyChangeParameter(originalUserKey, targetUserKey, Contexts.nullContext()))).filter(ServiceResult::isValid).findFirst().orElseThrow(() -> new Exception(String.format("failed to update user key from %s to %s", originalUserKey, targetUserKey)));
    }

    public static int getNumberOfTasks(PluginAccessor pluginAccessor, String handlerKey, String originalUserKey, String targetUserKey) {
        return pluginAccessor.getEnabledModuleDescriptorsByClass(UserKeyChangeHandlerModuleDescriptor.class).stream().filter(descriptor -> handlerKey.equals(descriptor.getKey())).map(AbstractJiraModuleDescriptor::getModule).mapToInt(handler -> handler.getNumberOfTasks((Object)new UserPropertyChangeParameter(originalUserKey, targetUserKey, Contexts.nullContext()))).sum();
    }
}

