/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.pkqdsl.legacy;

import com.atlassian.rm.common.pkqdsl.legacy.ConnectionProvider;
import com.google.common.base.Function;
import java.sql.Connection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.pkqdsl.legacy.DatabaseAccessUtil")
public class DatabaseAccessUtil
implements InitializingBean,
DisposableBean {
    private static final AtomicReference<DatabaseAccessUtil> instance = new AtomicReference();
    @Autowired
    private ConnectionProvider connectionProvider;
    private final AtomicBoolean primed = new AtomicBoolean(false);

    public static void ensurePrimed() {
        DatabaseAccessUtil databaseAccessUtil = instance.get();
        if (databaseAccessUtil == null) {
            throw new IllegalStateException("bean is not ready");
        }
        databaseAccessUtil.doEnsurePrimed();
    }

    public void afterPropertiesSet() throws Exception {
        instance.set(this);
    }

    public void destroy() throws Exception {
        instance.set(null);
    }

    private void doEnsurePrimed() {
        if (!this.primed.get()) {
            this.connectionProvider.withConnection(new Function<Connection, Object>(){

                public Object apply(Connection connection) {
                    return DatabaseAccessUtil.this.primed.getAndSet(true);
                }
            });
        }
    }
}

