/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.dep.IDependencyDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

class BacklogSequencer {
    private static final Log LOGGER = Log.with(BacklogSequencer.class);

    BacklogSequencer() {
    }

    List<IProcessingItem> getProcessingItemSequence(IRoadmapProblem problem) {
        if (problem.getProcessingDefinition().isPullRequirementsUp()) {
            return this.generateSequencePullUpRequirements(problem.getBacklog().getDependencyDefinition());
        }
        return this.generateSequencePushDownDependents(problem.getBacklog().getDependencyDefinition());
    }

    private List<IProcessingItem> generateSequencePullUpRequirements(final IDependencyDefinition dependencies) {
        LOGGER.debug("generate item sequence pushing down dependents", new Object[0]);
        ArrayList sorted = Lists.newArrayList(dependencies.getProcessingItems());
        Collections.sort(sorted, new Comparator<IProcessingItem>(){

            @Override
            public int compare(IProcessingItem o1, IProcessingItem o2) {
                Set<IProcessingItem> o1Deps = dependencies.getTransitiveDependents(o1);
                if (o1Deps.contains(o2)) {
                    return -1;
                }
                Set<IProcessingItem> o2Deps = dependencies.getTransitiveDependents(o2);
                if (o2Deps.contains(o1)) {
                    return 1;
                }
                return Ints.compare((int)this.getMostPrio(o1, (Iterable<IProcessingItem>)Sets.difference(o1Deps, o2Deps)), (int)this.getMostPrio(o2, (Iterable<IProcessingItem>)Sets.difference(o2Deps, o1Deps)));
            }

            private int getMostPrio(IProcessingItem item, Iterable<IProcessingItem> items) {
                int minPrio = item.getPriority();
                for (IProcessingItem next : items) {
                    minPrio = Math.min(minPrio, next.getPriority());
                }
                return minPrio;
            }
        });
        LOGGER.debug("generated item sequence: %s", Iterables.toString((Iterable)sorted));
        return sorted;
    }

    private List<IProcessingItem> generateSequencePushDownDependents(final IDependencyDefinition dependencies) {
        LOGGER.debug("generate item sequence pushing down dependents", new Object[0]);
        ArrayList sorted = Lists.newArrayList(dependencies.getProcessingItems());
        Collections.sort(sorted, new Comparator<IProcessingItem>(){

            @Override
            public int compare(IProcessingItem o1, IProcessingItem o2) {
                Set<IProcessingItem> o1Prereq = dependencies.getTransitivePrerequisites(o1);
                if (o1Prereq.contains(o2)) {
                    return 1;
                }
                Set<IProcessingItem> o2Prereq = dependencies.getTransitivePrerequisites(o2);
                if (o2Prereq.contains(o1)) {
                    return -1;
                }
                return Ints.compare((int)this.getLeastPrio(o1, (Iterable<IProcessingItem>)Sets.difference(o1Prereq, o2Prereq)), (int)this.getLeastPrio(o2, (Iterable<IProcessingItem>)Sets.difference(o2Prereq, o1Prereq)));
            }

            private int getLeastPrio(IProcessingItem item, Iterable<IProcessingItem> items) {
                int leastPrio = item.getPriority();
                for (IProcessingItem next : items) {
                    leastPrio = Math.max(leastPrio, next.getPriority());
                }
                return leastPrio;
            }
        });
        LOGGER.debug("generated item sequence: %s", Iterables.toString((Iterable)sorted));
        return sorted;
    }
}

