/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IActivitySetSchedulingTerminationCondition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IActivitySetSchedule;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class TimeLimitedTerminationCondition
implements IActivitySetSchedulingTerminationCondition {
    private static final Log LOGGER = Log.with(TimeLimitedTerminationCondition.class);
    private IActivitySetSchedule bestSchedule = null;
    private final int problemLimit;

    public TimeLimitedTerminationCondition(int timeLimit) {
        Preconditions.checkArgument((timeLimit >= 0 ? 1 : 0) != 0, (Object)("time limit must not be negative but was" + timeLimit));
        this.problemLimit = timeLimit;
    }

    @Override
    public boolean updateBestFoundSchedule(@Nullable IActivitySetSchedule activitySetSchedule) {
        if (activitySetSchedule == null) {
            return false;
        }
        LogUtil.debug(LOGGER, "try update with new schedule: %s", activitySetSchedule);
        if (this.bestSchedule == null) {
            LogUtil.debug(LOGGER, "best schedule was null - update");
            this.bestSchedule = activitySetSchedule;
            return true;
        }
        if (this.bestSchedule.getWarnings().size() > activitySetSchedule.getWarnings().size()) {
            LogUtil.debug(LOGGER, "best schedule has more warnings - update");
            this.bestSchedule = activitySetSchedule;
            return true;
        }
        if (this.bestSchedule.getEnd() > activitySetSchedule.getEnd()) {
            LogUtil.debug(LOGGER, "best schedule has later end time - update");
            this.bestSchedule = activitySetSchedule;
            return true;
        }
        LogUtil.debug(LOGGER, "best schedule not updated");
        return false;
    }

    @Override
    public int getUpperTimeBound() {
        if (this.bestSchedule != null && this.bestSchedule.getWarnings().isEmpty()) {
            return Math.min(this.bestSchedule.getEnd(), this.problemLimit);
        }
        return this.problemLimit;
    }
}

