/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotItemsSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotWorkAssignment;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FixedSlotItemsSolutionMapImpl
implements FixedSlotItemsSolution {
    private final IWorkSlot slot;
    private final Map<IProcessingItem, Set<FixedSlotWorkAssignment>> workAssignments;
    private final Set<IScheduleWarning> warnings;
    private final Set<IScheduleViolation> violations;

    public FixedSlotItemsSolutionMapImpl(IWorkSlot workSlot, Map<IProcessingItem, Set<FixedSlotWorkAssignment>> workAssignments, Set<IScheduleWarning> warnings, Set<IScheduleViolation> violations) {
        this.slot = workSlot;
        this.workAssignments = workAssignments;
        this.warnings = warnings;
        this.violations = violations;
    }

    @Override
    public Set<IProcessingItem> getProcessingItems() {
        return this.workAssignments.keySet();
    }

    @Override
    public IWorkSlot getWorkSlot() {
        return this.slot;
    }

    @Override
    public IResourceGroup getResourceGroup() {
        return this.workAssignments.keySet().iterator().next().getAssignmentRestriction().getResourcePools().iterator().next().getResourceGroup();
    }

    @Override
    public Set<FixedSlotWorkAssignment> getWorkAssignments(final String assignmentId) {
        return Sets.filter(this.getWorkAssignments(), (Predicate)new Predicate<FixedSlotWorkAssignment>(){

            public boolean apply(FixedSlotWorkAssignment fixedSlotWorkAssignment) {
                return assignmentId.equals(fixedSlotWorkAssignment.getItemId());
            }
        });
    }

    @Override
    public Set<FixedSlotWorkAssignment> getWorkAssignments() {
        return RmCollectionUtils.getMergedSet(this.workAssignments.values());
    }

    @Override
    public Set<FixedSlotWorkAssignment> getWorkAssignmentsForStage(final String assignmentId, final String stageId) {
        return Sets.filter(this.getWorkAssignments(), (Predicate)new Predicate<FixedSlotWorkAssignment>(){

            public boolean apply(FixedSlotWorkAssignment fixedSlotWorkAssignment) {
                return assignmentId.equals(fixedSlotWorkAssignment.getItemId()) && stageId.equals(fixedSlotWorkAssignment.getProcessingStage().getId());
            }
        });
    }

    @Override
    public Set<IScheduleWarning> getWarnings() {
        return this.warnings;
    }

    @Override
    public Set<IScheduleViolation> getViolations() {
        return this.violations;
    }

    @Override
    public int getStart() {
        return this.slot.getStart();
    }

    @Override
    public int getEnd() {
        return this.slot.getEnd();
    }

    @Override
    public int getLength() {
        return this.slot.getLength();
    }

    @Override
    public boolean contains(int value) {
        return this.slot.contains(value);
    }

    @Override
    public Optional<IIntegerInterval> getOverlappingInterval(IIntegerInterval interval) {
        return this.slot.getOverlappingInterval(interval);
    }
}

