/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ActivityAssignmentProblemVariables;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ActivityAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.IndexedResourceSkillVariable;
import com.google.common.base.MoreObjects;

public class DefaultActivityAssignmentSolution
implements ActivityAssignmentSolution {
    private final float[][] assignmentMatrix;

    DefaultActivityAssignmentSolution(float[][] assignments) {
        this.assignmentMatrix = assignments;
    }

    @Override
    public int getResources() {
        return this.assignmentMatrix.length;
    }

    @Override
    public int getSkills() {
        if (this.assignmentMatrix.length == 0) {
            return 0;
        }
        return this.assignmentMatrix[0].length;
    }

    @Override
    public float getLoad(int r, int s) {
        return this.assignmentMatrix[r][s];
    }

    static DefaultActivityAssignmentSolution create(float[] result, ActivityAssignmentProblemVariables variables) {
        float[][] assignments = new float[variables.getResources()][variables.getSkills()];
        for (IndexedResourceSkillVariable variable : variables.getVariables()) {
            float[] fArray = assignments[variable.getResource()];
            int n = variable.getSkill();
            fArray[n] = fArray[n] + result[variable.getIndex()];
        }
        return new DefaultActivityAssignmentSolution(assignments);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("assignmentMatrix", (Object)this.assignmentMatrix).toString();
    }
}

