/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.activity.ActivityAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.ActivityAssignmentSubProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.PeriodAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultPeriodAssignmentProblem
implements PeriodAssignmentProblem {
    private final float[] availabilities;
    private final boolean[][] resourceSkills;
    private final int[] resourceAssignmentLimits;
    private final float[][] activityDemands;
    private final float[] activityWeights;
    private final boolean[][] activityToResource;
    private final int skills;

    DefaultPeriodAssignmentProblem(float[] availabilities, boolean[][] resourceSkills, int[] resourceAssignmentLimits, float[][] activityDemands, float[] activityWeights, boolean[][] activityToResource, int skills) {
        this.availabilities = availabilities;
        this.resourceSkills = resourceSkills;
        this.resourceAssignmentLimits = resourceAssignmentLimits;
        this.activityDemands = activityDemands;
        this.activityWeights = activityWeights;
        this.activityToResource = activityToResource;
        this.skills = skills;
    }

    @Override
    public int getSkills() {
        return this.skills;
    }

    @Override
    public int getResources() {
        return this.availabilities.length;
    }

    @Override
    public int getActivities() {
        return this.resourceAssignmentLimits.length;
    }

    @Override
    public float getAvailability(int resource) {
        return this.availabilities[resource];
    }

    @Override
    public float getDemand(int activity, int skill) {
        return this.activityDemands[activity][skill];
    }

    @Override
    public int getAssignedResourcesLimit(int activity) {
        return this.resourceAssignmentLimits[activity];
    }

    @Override
    public float getWeightSum() {
        return RmUtils.sum(this.activityWeights);
    }

    @Override
    public float getAvailabilitySum() {
        return RmUtils.sum(this.availabilities);
    }

    @Override
    public ActivityAssignmentProblem getSubProblem(int activity, List<Integer> resources, List<Float> availabilities) {
        return new ActivityAssignmentSubProblem(activity, resources, availabilities, this.resourceSkills, this.activityDemands);
    }

    @Override
    public float[] getRestrictedResourceAvailabilitiesCopy(int limit) {
        return Arrays.copyOf(this.availabilities, limit);
    }

    @Override
    public Set<Integer> getPossibleResourcesForActivity(int activity) {
        HashSet resources = Sets.newHashSetWithExpectedSize((int)this.getResources());
        block0: for (int r = 0; r < this.getResources(); ++r) {
            for (int s = 0; s < this.getSkills(); ++s) {
                if (!(this.activityDemands[activity][s] > 0.0f) || !this.resourceSkills[r][s] || !this.activityToResource[activity][r]) continue;
                resources.add(r);
                continue block0;
            }
        }
        return resources;
    }

    @Override
    public boolean isEmptyActivity(int activity) {
        for (int s = 0; s < this.getSkills(); ++s) {
            if (!(this.activityDemands[activity][s] > 0.0f)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<Integer> getNeededSkills(int activity) {
        HashSet neededSkills = Sets.newHashSet();
        for (int s = 0; s < this.getSkills(); ++s) {
            if (!(this.activityDemands[activity][s] > 0.0f)) continue;
            neededSkills.add(s);
        }
        return neededSkills;
    }

    @Override
    public Set<Integer> getAvailableSkills(int resource) {
        HashSet skills = Sets.newHashSet();
        for (int s = 0; s < this.getSkills(); ++s) {
            if (!this.resourceSkills[resource][s]) continue;
            skills.add(s);
        }
        return skills;
    }

    @Override
    public float getResourceAvailability(int r) {
        return this.availabilities[r];
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sum of weights", this.getWeightSum()).add("sum of availabilities", this.getAvailabilitySum()).add("availabilities", (Object)this.availabilities).add("resourceSkills", (Object)this.resourceSkills).add("resourceAssignmentLimits", (Object)this.resourceAssignmentLimits).add("activityDemands", (Object)this.activityDemands).add("activityWeights", (Object)this.activityWeights).toString();
    }

    public static Builder builder(int activities, int resources, int skills) {
        return new Builder(activities, resources, skills);
    }

    public static class Builder {
        private final float[] availabilities;
        private final boolean[][] resourceSkills;
        private final int[] resourceAssignmentLimits;
        private final float[][] activityDemands;
        private final float[] activityWeights;
        private boolean[][] activityToResource;
        private int skills;

        public Builder(int activities, int resources, int skills) {
            this.availabilities = new float[resources];
            this.resourceSkills = new boolean[resources][skills];
            this.resourceAssignmentLimits = new int[activities];
            this.activityDemands = new float[activities][skills];
            this.activityWeights = new float[activities];
            this.activityToResource = new boolean[activities][resources];
            this.skills = skills;
        }

        public Builder setAvailabilities(float availability) {
            for (int i = 0; i < this.availabilities.length; ++i) {
                this.availabilities[i] = availability;
            }
            return this;
        }

        public Builder setAssignmentLimits(int assignmentLimit) {
            for (int i = 0; i < this.resourceAssignmentLimits.length; ++i) {
                this.resourceAssignmentLimits[i] = assignmentLimit;
            }
            return this;
        }

        public Builder setAllSkills() {
            for (int i = 0; i < this.resourceSkills.length; ++i) {
                for (int j = 0; j < this.resourceSkills[0].length; ++j) {
                    this.resourceSkills[i][j] = true;
                }
            }
            return this;
        }

        public Builder setDemands(float demand) {
            for (int i = 0; i < this.activityDemands.length; ++i) {
                for (int j = 0; j < this.activityDemands[0].length; ++j) {
                    this.activityDemands[i][j] = demand;
                }
            }
            return this;
        }

        public Builder setDemands(int activity, float[] demand) {
            this.activityDemands[activity] = demand;
            return this;
        }

        public Builder setDemand(int activity, int skill, float demand) {
            this.activityDemands[activity][skill] = demand;
            return this;
        }

        public Builder setWeight(int activity, float weight) {
            this.activityWeights[activity] = weight;
            return this;
        }

        public Builder setSkills(int r, boolean[] skills) {
            this.resourceSkills[r] = skills;
            return this;
        }

        public Builder setAvailability(int r, float availability) {
            this.availabilities[r] = availability;
            return this;
        }

        public Builder setActivityToResourceAssignable(int a, int r) {
            this.activityToResource[a][r] = true;
            return this;
        }

        public Builder setNoAssignmentRestrictions() {
            for (int a = 0; a < this.activityDemands.length; ++a) {
                for (int r = 0; r < this.resourceSkills.length; ++r) {
                    this.setActivityToResourceAssignable(a, r);
                }
            }
            return this;
        }

        public DefaultPeriodAssignmentProblem build() {
            return new DefaultPeriodAssignmentProblem(this.availabilities, this.resourceSkills, this.resourceAssignmentLimits, this.activityDemands, this.activityWeights, this.activityToResource, this.skills);
        }

        public Builder setWeights(float weights) {
            for (int a = 0; a < this.activityWeights.length; ++a) {
                this.activityWeights[a] = weights;
            }
            return this;
        }

        public Builder setAssignmentLimit(int a, int limit) {
            this.resourceAssignmentLimits[a] = limit;
            return this;
        }

        public Builder setSkill(int r, int s, boolean hasSkill) {
            this.resourceSkills[r][s] = hasSkill;
            return this;
        }
    }
}

