/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.DecisionVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class BaseProblem {
    final Set<DecisionVariable> allWorkDecisionVariables;
    final List<IProcessingItem> items;
    final List<IWorkResource> resources;
    final IWorkSlot workSlot;
    final Map<String, ? extends PositivePrimitivesMap<IResourceType>> demands;
    private final List<String> assignmentIds;

    BaseProblem(Set<DecisionVariable> decisionVariables, List<IProcessingItem> items, IWorkSlot workSlot, List<IWorkResource> resources, Map<String, ? extends PositivePrimitivesMap<IResourceType>> demands) {
        this.allWorkDecisionVariables = decisionVariables;
        this.items = items;
        this.workSlot = workSlot;
        this.resources = resources;
        this.demands = demands;
        this.assignmentIds = BaseProblem.initAssignmentIds(decisionVariables);
    }

    private static List<String> initAssignmentIds(Set<DecisionVariable> decisionVariables) {
        LinkedHashSet assignmentIds = Sets.newLinkedHashSet();
        for (DecisionVariable variables : decisionVariables) {
            assignmentIds.add(variables.getAssignmentId());
        }
        return Lists.newArrayList((Iterable)assignmentIds);
    }

    IWorkSlot getWorkSlot() {
        return this.workSlot;
    }

    Set<DecisionVariable> getWorkDecisionVariables() {
        return this.allWorkDecisionVariables;
    }

    List<IWorkResource> getResources() {
        return this.resources;
    }

    List<IProcessingItem> getItems() {
        return this.items;
    }

    float getType(String assignmentId, IResourceType typeId) {
        return this.demands.get(assignmentId).get(typeId);
    }

    float getResourceValue(String id) {
        return this.getResource(id).getRestrictedAvailability(this.workSlot.getIndex());
    }

    private IWorkResource getResource(String id) {
        return (IWorkResource)RmIdentifiableUtils.tryFindElementWithId(id, this.resources).get();
    }

    Set<DecisionVariable> getVariablesItemTypeResources(final String assignmentId, final String typeId, final Set<String> resourceIds) {
        return Sets.filter(this.allWorkDecisionVariables, (Predicate)new Predicate<DecisionVariable>(){

            public boolean apply(DecisionVariable decisionVariable) {
                return assignmentId.equals(decisionVariable.getAssignmentId()) && typeId.equals(decisionVariable.getResourceType().getId()) && resourceIds.contains(decisionVariable.getResource().getId());
            }
        });
    }

    List<String> getAssignmentIds() {
        return this.assignmentIds;
    }

    Map<IResourceType, Set<DecisionVariable>> getTypeVariablesForAssignmentId(String assignmentId) {
        HashMap typeToVariables = Maps.newHashMap();
        for (DecisionVariable variable : this.allWorkDecisionVariables) {
            if (!variable.getAssignmentId().equals(assignmentId)) continue;
            RmUtils.addToKeyedSets(typeToVariables, variable.getResourceType(), variable);
        }
        return typeToVariables;
    }

    abstract Set<DecisionVariable> getLimitedVariablesForResource(String var1);

    abstract int getVariableCount();
}

