/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.BaseFixedSlotLpSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.BaseProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.DecisionVariable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.MaximizeWorkProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.LpLogging;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.ApacheUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.NoFeasibleSolutionException;
import org.apache.commons.math3.optim.linear.NonNegativeConstraint;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.linear.SimplexSolver;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;

class MaximizationProblemLpSolver
extends BaseFixedSlotLpSolver {
    private static final double DEFAULT_EPSILON = 0.001;
    private final SimplexSolver simplexSolver = new SimplexSolver(0.001);

    MaximizationProblemLpSolver() {
    }

    Optional<float[]> solve(MaximizeWorkProblem problem) {
        try {
            OptimizationData[] optData = MaximizationProblemLpSolver.transform(problem);
            LpLogging.logDebug(optData);
            return Optional.of((Object)RmUtils.toFloatArray(this.simplexSolver.optimize(optData).getPoint()));
        }
        catch (NoFeasibleSolutionException e) {
            return Optional.absent();
        }
    }

    private static OptimizationData[] transform(MaximizeWorkProblem problem) {
        ArrayList optData = Lists.newArrayList();
        optData.add(GoalType.MAXIMIZE);
        optData.add(MaximizationProblemLpSolver.createObjectiveFunction(problem));
        optData.add(MaximizationProblemLpSolver.createLinearConstraints(problem));
        optData.add(new NonNegativeConstraint(true));
        return optData.toArray(new OptimizationData[optData.size()]);
    }

    private static OptimizationData createLinearConstraints(MaximizeWorkProblem problem) {
        ArrayList constraints = Lists.newArrayList();
        constraints.addAll(MaximizationProblemLpSolver.createAvailabilityConstraintSet(problem));
        constraints.addAll(MaximizationProblemLpSolver.createStrictOpenSkillConstraintSet(problem));
        return new LinearConstraintSet(constraints);
    }

    private static List<LinearConstraint> createStrictOpenSkillConstraintSet(BaseProblem problem) {
        ArrayList constraints = Lists.newArrayList();
        for (String item : problem.getAssignmentIds()) {
            Map<IResourceType, Set<DecisionVariable>> typeVariables = problem.getTypeVariablesForAssignmentId(item);
            for (Map.Entry<IResourceType, Set<DecisionVariable>> entry : typeVariables.entrySet()) {
                constraints.add(new LinearConstraint(ApacheUtils.createSetCoefficients(entry.getValue(), problem.getVariableCount()), Relationship.LEQ, (double)problem.getType(item, entry.getKey())));
            }
        }
        return constraints;
    }

    private static OptimizationData createObjectiveFunction(MaximizeWorkProblem problem) {
        double[] coefficients = new double[problem.getVariableCount()];
        for (int i = 0; i < coefficients.length; ++i) {
            coefficients[i] = 1.0;
        }
        return new LinearObjectiveFunction(coefficients, 0.0);
    }
}

