/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.calculation.CancellationState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.ReachedPlanningHorizonException;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.IUnstructuredItemSchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.ItemSchedulingState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.OptionalUnstructuredItemScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.PartialUnstructuredItemStageProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.UnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.IUnstructuredStageSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.UnstructuredStageScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.IWorkAssignable;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.atlassian.rm.jpo.scheduling.util.RmSortableUtils;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.collect.BiMap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;

@Immutable
public class OptionalUnstructuredScheduler
implements OptionalUnstructuredItemScheduler {
    private static final Log LOGGER = Log.with(OptionalUnstructuredScheduler.class);
    private final IUnstructuredStageSolver unstructuredStageSolver;

    OptionalUnstructuredScheduler(IUnstructuredStageSolver unstructuredStageSolver) {
        this.unstructuredStageSolver = unstructuredStageSolver;
    }

    public OptionalUnstructuredScheduler(CancellationState cancellationState) {
        this(new UnstructuredStageScheduler(cancellationState));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<IUnstructuredItemSchedule> trySchedule(IUnstructuredItemSchedulingProblem problem) throws InterruptedException, ReachedPlanningHorizonException {
        Stopwatch stopwatch = SimonManager.getStopwatch("calculation.epic");
        Split split = stopwatch.start();
        try {
            PartialUnstructuredItemStageProblem nextStageProblem;
            LogUtil.debug(LOGGER, "schedule problem: %s", problem);
            ItemSchedulingState problemState = ItemSchedulingState.createInstance(problem);
            List<IMutableResourcePool> pools = RmSortableUtils.sort(problem.getMutableResourcePools());
            HashSet partialSchedules = Sets.newHashSet();
            HashSet failedForStages = Sets.newHashSet();
            HashSet stagesWorkedOn = Sets.newHashSet();
            while ((nextStageProblem = (PartialUnstructuredItemStageProblem)problemState.getNextStageSchedulingProblem(failedForStages).orNull()) != null) {
                IWorkAssignable bestFit = null;
                IMutableResourcePool bestPool = null;
                for (IMutableResourcePool pool : pools) {
                    Optional<IUnstructuredItemSchedule> schedule = this.unstructuredStageSolver.trySolveNextStageProblemForGroup(nextStageProblem, pool, (IUnstructuredItemSchedule)bestFit);
                    if (!this.isFirstScheduleSuperiorToSecond((IUnstructuredItemSchedule)schedule.orNull(), (IUnstructuredItemSchedule)bestFit)) continue;
                    bestFit = (IUnstructuredItemSchedule)schedule.get();
                    bestPool = pool;
                }
                IProcessingStage stage = nextStageProblem.getProcessingStage();
                if (bestFit != null) {
                    stagesWorkedOn.add(stage);
                    partialSchedules.add(bestFit);
                    bestPool.getMutableResourceGroup().schedule(bestFit.getWorkAssignments());
                    IAggregatedWorkPackage bestFitWorkPackage = bestFit.getAggregatedWorkPackage();
                    IProcessingStageWorkPackage doneWork = (IProcessingStageWorkPackage)bestFitWorkPackage.getWorkPackageForStage(stage).get();
                    IWorkAssignable workInterval = bestFit;
                    problemState.updateProblemState(doneWork, (IIntegerInterval)((Object)workInterval));
                    failedForStages.clear();
                    continue;
                }
                failedForStages.add(stage);
                if (!failedForStages.containsAll(problem.getWorkDemand().getSpecifiedStages())) continue;
                break;
            }
            if (!stagesWorkedOn.containsAll(problem.getWorkDemand().getSpecifiedStages())) {
                Set<IMutableResourcePool> mutableResourcePools = problem.getMutableResourcePools();
                BiMap<String, IMutableResourcePool> idMap = RmIdentifiableUtils.createIdMap(mutableResourcePools);
                for (IUnstructuredItemSchedule schedule : partialSchedules) {
                    String id = schedule.getInvolvedResourceGroups().iterator().next().getId();
                    IMutableResourcePool pool = (IMutableResourcePool)idMap.get(id);
                    pool.getMutableResourceGroup().unschedule(schedule.getWorkAssignments());
                }
                Iterator<IMutableResourcePool> iterator = this.handleReturn((Optional<IUnstructuredItemSchedule>)Optional.absent(), problem);
                return iterator;
            }
            Optional<IUnstructuredItemSchedule> schedule = UnstructuredItemSchedule.tryCreateFromPartialSchedules(Sets.newHashSet(problem.getProcessingItem().getWorkDemand().getSpecifiedStages()), partialSchedules, problemState.isItemFinished());
            LogUtil.debug(LOGGER, "created schedule: %s", schedule);
            Optional<IUnstructuredItemSchedule> optional = this.handleReturn(schedule, problem);
            return optional;
        }
        finally {
            split.stop();
        }
    }

    private Optional<IUnstructuredItemSchedule> handleReturn(Optional<IUnstructuredItemSchedule> schedule, IUnstructuredItemSchedulingProblem problem) throws ReachedPlanningHorizonException {
        if (!schedule.isPresent() && problem.isUpperTimeBoundPlanningHorizon()) {
            throw new ReachedPlanningHorizonException(problem.getId());
        }
        return schedule;
    }

    private boolean isFirstScheduleSuperiorToSecond(IUnstructuredItemSchedule schedule, IUnstructuredItemSchedule bestIterationSchedule) {
        if (schedule == null) {
            return false;
        }
        if (bestIterationSchedule == null) {
            return true;
        }
        return schedule.getEnd() < bestIterationSchedule.getEnd();
    }
}

