/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.AbstractWarning;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.WarningType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivity;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivitySet;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
public class WorkSlotExceededWarning
extends AbstractWarning {
    private final IActivity activity;
    private final IActivitySet activitySet;

    public WorkSlotExceededWarning(IActivitySet activitySet, IActivity activity) {
        super(activitySet.getId());
        Preconditions.checkNotNull((Object)activity, (Object)"activity must not be null");
        Preconditions.checkArgument((boolean)activitySet.getActivities().contains(activity), (Object)"activity is not part of the activity set");
        this.activitySet = activitySet;
        this.activity = activity;
    }

    public IActivity getActivity() {
        return this.activity;
    }

    public IActivitySet getActivitySet() {
        return this.activitySet;
    }

    @Override
    public WarningType getWarningType() {
        return WarningType.WorkSlotExceeded;
    }
}

