/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.ITeamAvailabilityFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkSlotFunction;
import java.util.Collection;

public class TeamAvailabilityFunction
implements ITeamAvailabilityFunction {
    private static final Log LOGGER = Log.with(TeamAvailabilityFunction.class);
    private final Collection<IWorkSlotFunction> resourceFunctions;
    private final int firstRegularTimeStep;
    private final boolean positiveEnding;

    private TeamAvailabilityFunction(Collection<IWorkSlotFunction> resourceFunctions, int firstRegularTimeStep, boolean positiveEnding) {
        this.resourceFunctions = resourceFunctions;
        this.firstRegularTimeStep = firstRegularTimeStep;
        this.positiveEnding = positiveEnding;
    }

    @Override
    public float getUnassignedWorkInWorkSlot(int slotIndex) {
        float sum = 0.0f;
        for (IWorkSlotFunction resourceFunction : this.resourceFunctions) {
            double resourceSupply = resourceFunction.getUnassignedWorkInWorkSlot(slotIndex);
            sum = (float)((double)sum + resourceSupply);
        }
        return sum;
    }

    @Override
    public float getRestrictedAvailability(int slotIndex) {
        float sum = 0.0f;
        for (IWorkSlotFunction resourceFunction : this.resourceFunctions) {
            double resourceSupply = resourceFunction.getRestrictedAvailability(slotIndex);
            sum = (float)((double)sum + resourceSupply);
        }
        return sum;
    }

    @Override
    public int getFirstRegularTimeStep() {
        return this.firstRegularTimeStep;
    }

    @Override
    public boolean isPositiveEnding() {
        return this.positiveEnding;
    }

    public static TeamAvailabilityFunction createInstance(Collection<IWorkSlotFunction> resourceFunctions) {
        LOGGER.debug("create instance", new Object[0]);
        int firstRegular = TeamAvailabilityFunction.getFirstRegularTimeStep(resourceFunctions);
        boolean positive = TeamAvailabilityFunction.isPositiveEnding(resourceFunctions);
        TeamAvailabilityFunction instance = new TeamAvailabilityFunction(resourceFunctions, firstRegular, positive);
        LOGGER.debug("created instance: %s", instance);
        return instance;
    }

    private static boolean isPositiveEnding(Collection<IWorkSlotFunction> resourceFunctions) {
        for (IWorkSlotFunction resourceFunction : resourceFunctions) {
            if (!resourceFunction.isPositiveEnding()) continue;
            return true;
        }
        return false;
    }

    private static int getFirstRegularTimeStep(Collection<IWorkSlotFunction> resourceFunctions) {
        int firstRegular = -1;
        for (IWorkSlotFunction resourceFunction : resourceFunctions) {
            firstRegular = Math.max(firstRegular, resourceFunction.getFirstRegularTimeStep());
        }
        return firstRegular;
    }
}

