/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math;

import java.util.List;

abstract class MathUtil {
    private MathUtil() {
    }

    static <T> int[][] generateAllCombinationsAsMatrix(List<List<T>> elements) {
        if (elements.isEmpty()) {
            return new int[0][];
        }
        int combinationCount = MathUtil.calculateCombinationCount(elements);
        int[][] selectionMatrix = new int[combinationCount][elements.size()];
        for (int column = 0; column < elements.size(); ++column) {
            int elementIndex = 0;
            int incrementBlockSize = MathUtil.calculateIncrementBlockSize(column, elements);
            for (int row = 1; row < combinationCount; ++row) {
                if (row % incrementBlockSize == 0) {
                    elementIndex = (elementIndex + 1) % elements.get(column).size();
                }
                selectionMatrix[row][column] = elementIndex;
            }
        }
        return selectionMatrix;
    }

    private static <T> int calculateIncrementBlockSize(int column, List<List<T>> elements) {
        if (column == elements.size() - 1) {
            return 1;
        }
        return MathUtil.calculateCombinationCount(elements.subList(column + 1, elements.size()));
    }

    private static <T> int calculateCombinationCount(List<List<T>> elements) {
        int product = 1;
        for (List<T> element : elements) {
            product *= element.size();
        }
        return product;
    }
}

