/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.WorkProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class VariableAvailabilityState {
    private final int indexOffset;
    private final float[] availabilities;

    private VariableAvailabilityState(int indexOffset, float[] availabilities) {
        this.indexOffset = indexOffset;
        this.availabilities = availabilities;
    }

    public float getAvailability(int index) {
        return this.availabilities[index - this.indexOffset];
    }

    public void reduce(int index, float assignedWorkUnits) {
        int arrayIndex;
        int n = arrayIndex = index - this.indexOffset;
        this.availabilities[n] = this.availabilities[n] - assignedWorkUnits;
    }

    public static VariableAvailabilityState init(List<IWorkSlot> workSlots, WorkProvider resource) {
        return VariableAvailabilityState.initFromIndices(VariableAvailabilityState.extractIndices(workSlots), resource);
    }

    private static List<Integer> extractIndices(List<IWorkSlot> workSlots) {
        Preconditions.checkNotNull(workSlots, (Object)"slot list must not be null");
        Preconditions.checkArgument((!workSlots.isEmpty() ? 1 : 0) != 0, (Object)"slot list must not be empty");
        ArrayList indices = Lists.newArrayListWithCapacity((int)workSlots.size());
        for (IWorkSlot slot : workSlots) {
            indices.add(slot.getIndex());
        }
        return indices;
    }

    public static VariableAvailabilityState initFromIndices(List<Integer> indices, WorkProvider resource) {
        Preconditions.checkNotNull(indices, (Object)"slot list must not be null");
        Preconditions.checkArgument((!indices.isEmpty() ? 1 : 0) != 0, (Object)"slot list must not be empty");
        Preconditions.checkNotNull((Object)resource, (Object)"resource must not be null");
        int minIndex = Integer.MAX_VALUE;
        int maxIndex = Integer.MIN_VALUE;
        for (int index : indices) {
            minIndex = Math.min(minIndex, index);
            maxIndex = Math.max(maxIndex, index);
        }
        float[] availabilities = VariableAvailabilityState.initiAvailabilities(minIndex, maxIndex, resource);
        return new VariableAvailabilityState(minIndex, availabilities);
    }

    private static float[] initiAvailabilities(int minIndex, int maxIndex, WorkProvider resource) {
        float[] availabilities = new float[maxIndex - minIndex + 1];
        for (int i = minIndex; i <= maxIndex; ++i) {
            availabilities[i - minIndex] = resource.getUnassignedWorkInWorkSlot(i);
        }
        return availabilities;
    }
}

