/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.AvailabilityConstraint;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.DemandConstraint;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.UnweightedAssignmentLpProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.WeightedAssignmentLpProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.ApacheUtils;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.NonNegativeConstraint;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;

@Immutable
class ApacheLpTransformer {
    private static final Log LOGGER = Log.with(ApacheLpTransformer.class);

    ApacheLpTransformer() {
    }

    OptimizationData[] transform(WeightedAssignmentLpProblem problem) {
        ArrayList optData = Lists.newArrayList();
        optData.add(GoalType.MINIMIZE);
        optData.add(new LinearObjectiveFunction(problem.getWeightCoefficients(), 0.0));
        optData.add(this.createLinearConstraints(problem));
        optData.add(new NonNegativeConstraint(true));
        LogUtil.debugCollection(LOGGER, "created optimization data: %s", optData);
        return optData.toArray(new OptimizationData[optData.size()]);
    }

    private OptimizationData createLinearConstraints(UnweightedAssignmentLpProblem problem) {
        ArrayList constraints = Lists.newArrayList();
        List<LinearConstraint> availabilityConstraints = this.createAvailabilityConstraintSet(problem);
        constraints.addAll(availabilityConstraints);
        List<LinearConstraint> openSkillConstraints = this.createOpenSkillConstraintSet(problem);
        constraints.addAll(openSkillConstraints);
        return new LinearConstraintSet(constraints);
    }

    private List<LinearConstraint> createOpenSkillConstraintSet(UnweightedAssignmentLpProblem problem) {
        ArrayList constraints = Lists.newArrayListWithCapacity((int)problem.getDemandConstraints().size());
        for (DemandConstraint demandConstraint : problem.getDemandConstraints()) {
            double[] coefficients = ApacheUtils.createOneCoefficients(demandConstraint.getIndices(), problem.getVariableCount());
            LinearConstraint constraint = new LinearConstraint(coefficients, Relationship.EQ, (double)demandConstraint.getValue());
            constraints.add(constraint);
        }
        return constraints;
    }

    private List<LinearConstraint> createAvailabilityConstraintSet(UnweightedAssignmentLpProblem problem) {
        ArrayList constraints = Lists.newArrayListWithCapacity((int)problem.getAvailabilityConstraints().size());
        for (AvailabilityConstraint availabilityConstraint : problem.getAvailabilityConstraints()) {
            double[] coefficients = ApacheUtils.createOneCoefficients(availabilityConstraint.getIndices(), problem.getVariableCount());
            LinearConstraint constraint = new LinearConstraint(coefficients, Relationship.LEQ, (double)availabilityConstraint.getValue());
            constraints.add(constraint);
        }
        return constraints;
    }
}

