/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.support;

import com.google.common.collect.ImmutableList;
import com.mysema.query.JoinFlag;
import com.mysema.query.QueryFlag;
import com.mysema.query.support.Normalization;
import com.mysema.query.types.Constant;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Operator;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathType;
import com.mysema.query.types.Template;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.Templates;
import com.mysema.query.types.Visitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SerializerBase<S extends SerializerBase<S>>
implements Visitor<Void, Void> {
    private final StringBuilder builder = new StringBuilder(128);
    private String constantPrefix = "a";
    private String paramPrefix = "p";
    private String anonParamPrefix = "_";
    private Map<Object, String> constantToLabel;
    private final S self = this;
    private final Templates templates;
    private final char escape;
    private boolean normalize = true;
    private boolean strict = true;

    public SerializerBase(Templates templates) {
        this.templates = templates;
        this.escape = templates.getEscapeChar();
    }

    public final S prepend(String str) {
        this.builder.insert(0, str);
        return this.self;
    }

    public final S insert(int position, String str) {
        this.builder.insert(position, str);
        return this.self;
    }

    public final S append(String str) {
        this.builder.append(str);
        return this.self;
    }

    protected String getConstantPrefix() {
        return this.constantPrefix;
    }

    public Map<Object, String> getConstantToLabel() {
        if (this.constantToLabel == null) {
            this.constantToLabel = new HashMap<Object, String>(4);
        }
        return this.constantToLabel;
    }

    public int getLength() {
        return this.builder.length();
    }

    protected final Template getTemplate(Operator<?> op) {
        return this.templates.getTemplate(op);
    }

    public final S handle(Expression<?> expr) {
        expr.accept(this, null);
        return this.self;
    }

    public final S handle(Object arg) {
        if (arg instanceof Expression) {
            ((Expression)arg).accept(this, null);
        } else {
            this.visitConstant(arg);
        }
        return this.self;
    }

    public final S handle(JoinFlag joinFlag) {
        return this.handle(joinFlag.getFlag());
    }

    public final S handle(String sep, Expression<?>[] expressions) {
        for (int i = 0; i < expressions.length; ++i) {
            if (i != 0) {
                this.append(sep);
            }
            this.handle(expressions[i]);
        }
        return this.self;
    }

    public final S handle(String sep, List<?> expressions) {
        for (int i = 0; i < expressions.size(); ++i) {
            if (i != 0) {
                this.append(sep);
            }
            this.handle((Expression)expressions.get(i));
        }
        return this.self;
    }

    protected void handleTemplate(Template template, List<?> args) {
        for (Template.Element element : template.getElements()) {
            Object rv = element.convert(args);
            if (rv instanceof Expression) {
                ((Expression)rv).accept(this, null);
                continue;
            }
            if (element.isString()) {
                this.builder.append(rv.toString());
                continue;
            }
            this.visitConstant(rv);
        }
    }

    public final boolean serialize(QueryFlag.Position position, Set<QueryFlag> flags) {
        boolean handled = false;
        for (QueryFlag flag : flags) {
            if (flag.getPosition() != position) continue;
            this.handle(flag.getFlag());
            handled = true;
        }
        return handled;
    }

    public final boolean serialize(JoinFlag.Position position, Set<JoinFlag> flags) {
        boolean handled = false;
        for (JoinFlag flag : flags) {
            if (flag.getPosition() != position) continue;
            this.handle(flag.getFlag());
            handled = true;
        }
        return handled;
    }

    public void setConstantPrefix(String prefix) {
        this.constantPrefix = prefix;
    }

    public void setParamPrefix(String prefix) {
        this.paramPrefix = prefix;
    }

    public void setAnonParamPrefix(String prefix) {
        this.anonParamPrefix = prefix;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public String toString() {
        if (this.normalize) {
            return Normalization.normalize(this.builder.toString());
        }
        return this.builder.toString();
    }

    @Override
    public final Void visit(Constant<?> expr, Void context) {
        this.visitConstant(expr.getConstant());
        return null;
    }

    public void visitConstant(Object constant) {
        if (!this.getConstantToLabel().containsKey(constant)) {
            String constLabel = this.constantPrefix + (this.getConstantToLabel().size() + 1);
            this.getConstantToLabel().put(constant, constLabel);
            this.append(constLabel);
        } else {
            this.append(this.getConstantToLabel().get(constant));
        }
    }

    @Override
    public Void visit(ParamExpression<?> param, Void context) {
        String paramLabel = param.isAnon() ? this.anonParamPrefix + param.getName() : this.paramPrefix + param.getName();
        this.getConstantToLabel().put(param, paramLabel);
        this.append(paramLabel);
        return null;
    }

    @Override
    public Void visit(TemplateExpression<?> expr, Void context) {
        this.handleTemplate(expr.getTemplate(), expr.getArgs());
        return null;
    }

    @Override
    public Void visit(FactoryExpression<?> expr, Void context) {
        this.handle(", ", expr.getArgs());
        return null;
    }

    @Override
    public Void visit(Operation<?> expr, Void context) {
        this.visitOperation(expr.getType(), expr.getOperator(), expr.getArgs());
        return null;
    }

    @Override
    public Void visit(Path<?> path, Void context) {
        PathType pathType = path.getMetadata().getPathType();
        Template template = this.templates.getTemplate(pathType);
        Object element = path.getMetadata().getElement();
        ImmutableList args = path.getMetadata().getParent() != null ? ImmutableList.of(path.getMetadata().getParent(), (Object)element) : ImmutableList.of((Object)element);
        this.handleTemplate(template, (List<?>)args);
        return null;
    }

    protected void visitOperation(Class<?> type, Operator<?> operator, List<? extends Expression<?>> args) {
        Template template = this.templates.getTemplate(operator);
        if (template != null) {
            int precedence = this.templates.getPrecedence(operator);
            for (Template.Element element : template.getElements()) {
                Object rv = element.convert(args);
                if (rv instanceof Expression) {
                    Expression expr = (Expression)rv;
                    if (precedence > -1 && expr instanceof Operation) {
                        if (precedence < this.templates.getPrecedence(((Operation)expr).getOperator())) {
                            ((SerializerBase)((SerializerBase)this.append("(")).handle(expr)).append(")");
                            continue;
                        }
                        this.handle(expr);
                        continue;
                    }
                    this.handle(expr);
                    continue;
                }
                if (element.isString()) {
                    this.append(rv.toString());
                    continue;
                }
                this.visitConstant(rv);
            }
        } else {
            if (this.strict) {
                throw new IllegalArgumentException("Got no pattern for " + operator);
            }
            this.append(operator.toString());
            this.append("(");
            this.handle(", ", args);
            this.append(")");
        }
    }
}

