/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.plugins.jira.views;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.radiantminds.plugins.jira.views.VelocityAccess;
import com.radiantminds.roadmap.api.PluginPermission;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioCustomWordingPersistence;
import com.radiantminds.roadmap.common.extensions.features.FeatureExtension;
import com.radiantminds.roadmap.common.permissions.PluginPermissions;
import com.radiantminds.roadmap.common.utils.meta.MetaDataUtils;
import com.radiantminds.roadmap.jira.common.components.agile.JiraAgileAccessor;
import com.radiantminds.roadmap.jira.common.components.utils.Distribution;
import com.radiantminds.roadmap.jira.common.components.utils.JiraPropertyUtil;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;

public class BaseMetaAwareView
extends JiraWebActionSupport {
    private static final Log LOGGER = Log.with(BaseMetaAwareView.class);
    private final PortfolioCustomWordingPersistence customWordingPersistence;
    protected final PluginPermissions pluginPermissionHandler;
    protected final PluginLicenseManager licenseManager;
    protected final FeatureManager featureManager;
    protected final ApplicationProperties applicationProperties;
    protected final FeatureExtension featureExtension;
    protected final JiraAgileAccessor agileAccessor;
    protected final MetaDataUtils metaDataUtils;
    private Map<String, String> customWording;

    public BaseMetaAwareView(PluginPermissions pluginPermissionHandler, PluginLicenseManager licenseManager, FeatureManager featureManager, FeatureExtension featureExtension, ApplicationProperties applicationProperties, PortfolioCustomWordingPersistence customWordingPersistence, JiraAgileAccessor agileAccessor, MetaDataUtils metaDataUtils) {
        this.pluginPermissionHandler = pluginPermissionHandler;
        this.licenseManager = licenseManager;
        this.featureManager = featureManager;
        this.featureExtension = featureExtension;
        this.applicationProperties = applicationProperties;
        this.customWordingPersistence = customWordingPersistence;
        this.agileAccessor = agileAccessor;
        this.metaDataUtils = metaDataUtils;
    }

    @VelocityAccess
    public String getDevelopmentMode() {
        return BaseMetaAwareView.toBooleanString(this.getHttpRequest().getParameter("devmode"));
    }

    @VelocityAccess
    public String getDistribution() {
        return Distribution.isOnDemand(this.featureManager) ? "od" : "btf";
    }

    @VelocityAccess
    public String getRoadmapsVersion() {
        return this.metaDataUtils.getVersion().toString();
    }

    @VelocityAccess
    public String getClientId() {
        return UUID.randomUUID().toString();
    }

    @VelocityAccess
    public String getJiraTitle() {
        return JiraPropertyUtil.getValueOrDefault(this.applicationProperties, "jira.title");
    }

    @VelocityAccess
    public String getJiraEdition() {
        return JiraPropertyUtil.getValueOrDefault(this.applicationProperties, "jira.edition");
    }

    @VelocityAccess
    public String getJiraVersion() {
        return JiraPropertyUtil.getValueOrDefault(this.applicationProperties, "jira.version");
    }

    @VelocityAccess
    public String getSupportEntitlementNumber() {
        return this.licenseManager.getLicense().isDefined() && ((PluginLicense)this.licenseManager.getLicense().get()).getSupportEntitlementNumber().isDefined() ? (String)((PluginLicense)this.licenseManager.getLicense().get()).getSupportEntitlementNumber().get() : "Unknown";
    }

    @VelocityAccess
    public Map<String, String> getCustomWording() {
        if (this.customWording == null) {
            try {
                this.customWording = (Map)MoreObjects.firstNonNull(this.customWordingPersistence.getCustomWordings(), (Object)Maps.newHashMap());
            }
            catch (SQLException exception) {
                LOGGER.error("Failed to load custom wording.", new Object[0]);
                LOGGER.exception(exception, Log.LogLevel.ERROR);
                this.customWording = Maps.newHashMap();
            }
        }
        return this.customWording;
    }

    @VelocityAccess
    public String isRenaissanceEnabled() {
        return BaseMetaAwareView.toBooleanString(this.agileAccessor.isRenaissanceEnabled());
    }

    @VelocityAccess
    public boolean isAgileUsable() {
        return this.agileAccessor.isUsable();
    }

    @VelocityAccess
    public String getJiraAgileVersion() throws Exception {
        Optional<String> version = this.agileAccessor.getVersion();
        if (version.isPresent()) {
            return (String)version.get();
        }
        return null;
    }

    @VelocityAccess
    public String isLabsAccess() throws Exception {
        return BaseMetaAwareView.toBooleanString(this.pluginPermissionHandler.check(PluginPermission.LabsAccess));
    }

    @VelocityAccess
    public String isClientExceptionsEnabled() {
        return BaseMetaAwareView.toBooleanString(this.featureExtension.isClientSideExceptionsBummerEnabled());
    }

    @VelocityAccess
    public boolean isRebrandEnabled() {
        return this.featureExtension.isRebrandEnabled();
    }

    protected static final String toBooleanString(boolean bool) {
        return bool ? "true" : "false";
    }

    protected static final String toBooleanString(Object val) {
        return BaseMetaAwareView.toBooleanString(val != null);
    }
}

