/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.plugins.jira.views.roadmap;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.rm.common.bridges.jira.event.mau.MauEventServiceBridgeProxy;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.opensymphony.module.propertyset.PropertySet;
import com.radiantminds.plugins.jira.utils.RecentPlansProvider;
import com.radiantminds.plugins.jira.utils.UserPropertyManagerWrapper;
import com.radiantminds.plugins.jira.views.BaseAutheticatedRoadmapsView;
import com.radiantminds.plugins.jira.views.VelocityAccess;
import com.radiantminds.roadmap.api.PluginPermission;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioCustomWordingPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.features.FeatureExtension;
import com.radiantminds.roadmap.common.extensions.settings.SettingsExtension;
import com.radiantminds.roadmap.common.permissions.PlanPermission;
import com.radiantminds.roadmap.common.permissions.PlanPermissionAuthentication;
import com.radiantminds.roadmap.common.permissions.PlanPermissions;
import com.radiantminds.roadmap.common.permissions.PluginPermissions;
import com.radiantminds.roadmap.common.utils.meta.MetaDataUtils;
import com.radiantminds.roadmap.jira.common.analytics.PlanPageLoadEvent;
import com.radiantminds.roadmap.jira.common.components.agile.JiraAgileAccessor;
import com.radiantminds.roadmap.jira.common.components.extension.licenses.JiraLicenseExtension;
import com.radiantminds.roadmap.jira.common.components.utils.JiraPropertyUtil;
import java.util.Collection;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.math.NumberUtils;

public class RoadmapAction
extends BaseAutheticatedRoadmapsView {
    public static final String ACCESS_EDITOR_FULL = "editor-full";
    public static final String ACCESS_EDITOR_NONPUB = "editor-nonpub";
    public static final String ACCESS_VIEWER = "viewer";
    private final EventPublisher eventPublisher;
    private final PortfolioPlanPersistence planPersistence;
    private final PluginPermissions pluginPermissionHandler;
    private final PlanPermissions planPermissionHandler;
    private final SettingsExtension settingsExtension;
    private final FeatureExtension featureExtension;
    private final PropertySet propertySet;
    private final ApplicationUser applicationUser;
    private IPlan currentPlan = null;
    private String accessMode = null;
    private PlanPermissionAuthentication explicitPlanAuthEditor = PlanPermissionAuthentication.Denied;
    private PlanPermissionAuthentication explicitPlanAuthViewer = PlanPermissionAuthentication.Denied;

    public RoadmapAction(PluginLicenseManager licenseManager, FeatureManager featureManager, UserPropertyManager userPropertyManager, JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, EventPublisher eventPublisher, MauEventServiceBridgeProxy mauEventServiceBridgeProxy, PortfolioPlanPersistence planPersistence, PluginPermissions pluginPermissionsHandler, PlanPermissions planPermissionHandler, PortfolioCustomWordingPersistence customWordingPersistence, FeatureExtension featureExtension, SettingsExtension settingsExtension, JiraAgileAccessor agileAccessor, MetaDataUtils metaDataUtils, JiraLicenseExtension jiraLicenseExtension) {
        super(PluginPermission.or(PluginPermission.FullEditor, PluginPermission.NonPublishingEditor, PluginPermission.Viewer), authenticationContext, licenseManager, featureManager, featureExtension, applicationProperties, pluginPermissionsHandler, customWordingPersistence, agileAccessor, metaDataUtils, mauEventServiceBridgeProxy, jiraLicenseExtension);
        this.eventPublisher = eventPublisher;
        this.planPersistence = planPersistence;
        this.pluginPermissionHandler = pluginPermissionsHandler;
        this.planPermissionHandler = planPermissionHandler;
        this.settingsExtension = settingsExtension;
        this.applicationUser = authenticationContext.getUser();
        this.featureExtension = featureExtension;
        this.propertySet = this.applicationUser != null ? userPropertyManager.getPropertySet(this.applicationUser) : null;
    }

    @Override
    public String execute() throws Exception {
        String retVal;
        String planIdStr = this.getHttpRequest().getParameter("id");
        Optional<Long> planId = this.parseLongToOptional(planIdStr);
        if (planId.isPresent()) {
            if (this.applicationUser == null) {
                return "permissionviolation";
            }
            this.explicitPlanAuthEditor = this.planPermissionHandler.check(planIdStr, PlanPermission.Editor).getAuthentication(PlanPermission.Editor);
            this.explicitPlanAuthViewer = this.planPermissionHandler.check(planIdStr, PlanPermission.Viewer).getAuthentication(PlanPermission.Viewer);
            if (this.explicitPlanAuthEditor == PlanPermissionAuthentication.Denied && this.explicitPlanAuthViewer == PlanPermissionAuthentication.Denied) {
                return "permissionviolation";
            }
            if (this.propertySet != null) {
                RecentPlansProvider recentPlansProviderJPO11 = new RecentPlansProvider(this.planPersistence, new UserPropertyManagerWrapper(this.propertySet));
                recentPlansProviderJPO11.add((Long)planId.get());
            }
        }
        if ("success".equals(retVal = super.execute())) {
            this.eventPublisher.publish((Object)new PlanPageLoadEvent(this.getAccessMode(), this.getJiraAgileVersion() != null));
        }
        super.tagCurrentRequestForMauTrackingIfSuccessful(retVal);
        return retVal;
    }

    private Optional<Long> parseLongToOptional(String longId) {
        if (longId != null && NumberUtils.isDigits((String)longId)) {
            return Optional.fromNullable((Object)Long.parseLong(longId));
        }
        return Optional.absent();
    }

    @VelocityAccess
    public String getPlanId() {
        return this.getPlanString(new Function<IPlan, String>(){

            public String apply(IPlan plan) {
                return plan.getId();
            }
        });
    }

    @VelocityAccess
    public String getPlanTitle() {
        return this.getPlanString(new Function<IPlan, String>(){

            public String apply(IPlan plan) {
                return plan.getTitle();
            }
        }, "(Untitled Plan)");
    }

    @VelocityAccess
    public String getPlanDetails() {
        return this.getPlanString(new Function<IPlan, String>(){

            public String apply(IPlan plan) {
                return plan.getDetails();
            }
        });
    }

    @VelocityAccess
    public String getAccessMode() throws Exception {
        if (this.accessMode == null) {
            this.accessMode = this.getAccessModeNonCached();
        }
        return this.accessMode;
    }

    @VelocityAccess
    public String getDateFormat() {
        return JiraPropertyUtil.getValueOrDefault(this.applicationProperties, "jira.lf.date.dmy");
    }

    @VelocityAccess
    public String getDaysPerWeek() {
        return JiraPropertyUtil.getValueOrDefault(this.applicationProperties, "jira.timetracking.days.per.week");
    }

    @VelocityAccess
    public String getHoursPerDay() {
        return this.settingsExtension.getHoursPerDaySetting();
    }

    @VelocityAccess
    public String getAutomaticCalculationEnabled() {
        return RoadmapAction.toBooleanString(this.featureExtension.isAutomaticCalculationOptionEnabled());
    }

    @VelocityAccess
    public String getFeedbackButtonEnabled() {
        return RoadmapAction.toBooleanString(this.featureExtension.isFeedbackButtonEnabled());
    }

    public String getTimeLineAnonymized() {
        return RoadmapAction.toBooleanString(this.featureExtension.isTimeLineAnonymized());
    }

    public String getBusinessValueColumnEnabled() {
        return RoadmapAction.toBooleanString(this.featureExtension.isBusinessValueColumnEnabled());
    }

    private String getPlanString(Function<IPlan, String> planStringFunction) {
        return this.getPlanString(planStringFunction, "");
    }

    private String getPlanString(Function<IPlan, String> planStringFunction, String defaultString) {
        if (this.currentPlan == null) {
            this.currentPlan = this.fetchPlan();
        }
        if (this.currentPlan == null) {
            return "";
        }
        String retVal = (String)planStringFunction.apply((Object)this.currentPlan);
        return (String)MoreObjects.firstNonNull((Object)retVal, (Object)defaultString);
    }

    private IPlan fetchPlan() {
        try {
            String planId = this.getHttpRequest().getParameter("id");
            IPlan plan = this.planPersistence.getPlanWithCustomQuery(planId, false);
            if (plan.getTitle() == null) {
                plan.setTitle("(Untitled Plan)");
            }
            if (plan.getDetails() == null) {
                plan.setDetails("");
            }
            plan.setDetails(StringEscapeUtils.escapeJavaScript((String)plan.getDetails()));
            return plan;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public boolean skipPluginLevelAuthentication() {
        return this.explicitPlanAuthEditor == PlanPermissionAuthentication.Authorized || this.explicitPlanAuthViewer == PlanPermissionAuthentication.Authorized;
    }

    private String getAccessModeNonCached() throws Exception {
        String planId = this.getPlanId();
        if (planId != null) {
            Collection<PlanPermission> planPermissions = this.planPermissionHandler.getPlanPermissions(planId);
            if (planPermissions.contains((Object)PlanPermission.Editor)) {
                if (this.explicitPlanAuthEditor == PlanPermissionAuthentication.Authorized || this.pluginPermissionHandler.check(PluginPermission.or(PluginPermission.Admin, PluginPermission.FullEditor))) {
                    return ACCESS_EDITOR_FULL;
                }
                if (this.pluginPermissionHandler.check(PluginPermission.NonPublishingEditor)) {
                    return ACCESS_EDITOR_NONPUB;
                }
                if (this.pluginPermissionHandler.check(PluginPermission.Viewer)) {
                    return ACCESS_VIEWER;
                }
            } else if (planPermissions.contains((Object)PlanPermission.Viewer) && (this.explicitPlanAuthViewer == PlanPermissionAuthentication.Authorized || this.pluginPermissionHandler.check(PluginPermission.or(PluginPermission.Admin, PluginPermission.FullEditor, PluginPermission.NonPublishingEditor, PluginPermission.Viewer)))) {
                return ACCESS_VIEWER;
            }
        }
        return ACCESS_VIEWER;
    }
}

