/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PluginPermission {
    Admin,
    FullEditor,
    NonPublishingEditor,
    Viewer,
    LabsAccess,
    TeamManagementAccess;


    public static Or or(PluginPermission ... pluginPermissions) {
        return new Or(pluginPermissions);
    }

    public static Or or(Collection<PluginPermission> pluginPermissions) {
        return new Or(pluginPermissions);
    }

    public static class Or {
        private final Collection<PluginPermission> permissions;

        public Or(PluginPermission ... permissions) {
            this.permissions = Arrays.stream(permissions).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        public Or(Collection<PluginPermission> permissions) {
            this.permissions = permissions.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        }

        public Collection<PluginPermission> getPermissions() {
            return this.permissions;
        }

        public Collection<PluginPermission> getWithMorePermissive() {
            return this.permissions.stream().flatMap(this::getWithMorePermissive).collect(Collectors.toSet());
        }

        private Stream<PluginPermission> getWithMorePermissive(PluginPermission pluginPermission) {
            switch (pluginPermission) {
                case FullEditor: {
                    return Stream.of(Admin, FullEditor);
                }
                case NonPublishingEditor: {
                    return Stream.of(Admin, FullEditor, NonPublishingEditor);
                }
                case Viewer: {
                    return Stream.of(Admin, FullEditor, NonPublishingEditor, Viewer);
                }
                case TeamManagementAccess: {
                    return Stream.of(Admin, TeamManagementAccess);
                }
            }
            return Stream.of(pluginPermission);
        }
    }
}

