/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.rand.backlog;

import com.radiantminds.roadmap.common.data.generator.rand.backlog.IRandomizedBacklogConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.IRandomizedStructuredEpicConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.IRandomizedUnstructuredEpicConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.RandomizedStructuredEpicConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.backlog.RandomizedUnstructuredEpicConfiguration;

public class RandomizedBacklogConfiguration
implements IRandomizedBacklogConfiguration {
    private final int epicCount;
    private final double structuredEpicPercentage;
    private final IRandomizedStructuredEpicConfiguration structuredEpicConfiguration;
    private final IRandomizedUnstructuredEpicConfiguration unstructuredEpicConfiguration;

    protected RandomizedBacklogConfiguration(int epicCount, double structuredEpicPercentage, IRandomizedStructuredEpicConfiguration structuredEpicConfiguration, IRandomizedUnstructuredEpicConfiguration unstructuredEpicConfiguration) {
        this.epicCount = epicCount;
        this.structuredEpicPercentage = structuredEpicPercentage;
        this.structuredEpicConfiguration = structuredEpicConfiguration;
        this.unstructuredEpicConfiguration = unstructuredEpicConfiguration;
    }

    @Override
    public int getEpicCount() {
        return this.epicCount;
    }

    @Override
    public double getStructuredEpicPercentage() {
        return this.structuredEpicPercentage;
    }

    @Override
    public IRandomizedStructuredEpicConfiguration getStructuredEpicConfiguration() {
        return this.structuredEpicConfiguration;
    }

    @Override
    public IRandomizedUnstructuredEpicConfiguration getUnstructuredEpicConfiguration() {
        return this.unstructuredEpicConfiguration;
    }

    public static class Builder {
        private int epicCount = 20;
        private double structuredEpicPercentage = 0.5;
        private IRandomizedStructuredEpicConfiguration structuredEpicConfiguration = new RandomizedStructuredEpicConfiguration.Builder().build();
        private IRandomizedUnstructuredEpicConfiguration unstructuredEpicConfiguration = new RandomizedUnstructuredEpicConfiguration.Builder().build();

        public Builder withEpicCount(int epicCount) {
            this.epicCount = epicCount;
            return this;
        }

        public Builder withStructuredEpicPercentage(double structuredEpicPercentage) {
            this.structuredEpicPercentage = structuredEpicPercentage;
            return this;
        }

        public Builder withStructuredEpicConfiguration(IRandomizedStructuredEpicConfiguration structuredEpicConfiguration) {
            this.structuredEpicConfiguration = structuredEpicConfiguration;
            return this;
        }

        public Builder withUnstructuredEpicConfiguration(IRandomizedUnstructuredEpicConfiguration unstructuredEpicConfiguration) {
            this.unstructuredEpicConfiguration = unstructuredEpicConfiguration;
            return this;
        }

        public RandomizedBacklogConfiguration build() {
            return new RandomizedBacklogConfiguration(this.epicCount, this.structuredEpicPercentage, this.structuredEpicConfiguration, this.unstructuredEpicConfiguration);
        }
    }
}

