/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.teams;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.generator.teams.IAbilityConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.IAbsenceConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.IAvailabilityConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.IPresenceConfiguration;
import com.radiantminds.roadmap.common.data.generator.teams.IResourceConfiguration;
import java.util.List;
import java.util.Set;

public class ResourceConfiguration
implements IResourceConfiguration {
    private final String title;
    private final Set<IAbilityConfiguration> abilityConfigurations;
    private final Double availability;
    private final Set<IPresenceConfiguration> presenceConfigurations;
    private final Set<IAbsenceConfiguration> absenceConfigurations;
    private final List<IAvailabilityConfiguration> availabilityConfigurations;

    public ResourceConfiguration(String title, Set<IAbilityConfiguration> abilityConfigurations, Double availability, Set<IPresenceConfiguration> presenceConfigurations, Set<IAbsenceConfiguration> absenceConfigurations, List<IAvailabilityConfiguration> availabilityConfigurations) {
        this.title = title;
        this.abilityConfigurations = abilityConfigurations;
        this.availability = availability;
        this.presenceConfigurations = presenceConfigurations;
        this.absenceConfigurations = absenceConfigurations;
        this.availabilityConfigurations = availabilityConfigurations;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Set<IAbilityConfiguration> getAbilityConfigurations() {
        return this.abilityConfigurations;
    }

    @Override
    public Optional<Double> getAvailability() {
        return Optional.fromNullable((Object)this.availability);
    }

    @Override
    public Set<IPresenceConfiguration> getPresenceConfigurations() {
        return this.presenceConfigurations;
    }

    @Override
    public Set<IAbsenceConfiguration> getAbsenceConfigurations() {
        return this.absenceConfigurations;
    }

    @Override
    public List<IAvailabilityConfiguration> getAvailabilityConfigurations() {
        return this.availabilityConfigurations;
    }

    public static class Builder {
        private final String title;
        private Set<IAbilityConfiguration> abilityConfigurations = Sets.newHashSet();
        private Double availability = null;
        private Set<IPresenceConfiguration> presences = Sets.newHashSet();
        private Set<IAbsenceConfiguration> absences = Sets.newHashSet();
        private List<IAvailabilityConfiguration> availabilities = Lists.newArrayList();

        public Builder(String title) {
            this.title = title;
        }

        public Builder withAbilityConfigurations(Set<IAbilityConfiguration> abilityConfigurations) {
            this.abilityConfigurations = abilityConfigurations;
            return this;
        }

        public Builder withAvailability(Double availability) {
            this.availability = availability;
            return this;
        }

        public Builder withPresenceConfigurations(Set<IPresenceConfiguration> presenceConfigurations) {
            this.presences = presenceConfigurations;
            return this;
        }

        public Builder withAbsenceConfigurations(Set<IAbsenceConfiguration> absenceConfigurations) {
            this.absences = absenceConfigurations;
            return this;
        }

        public Builder withAvailabilities(List<IAvailabilityConfiguration> availabilityConfigurations) {
            this.availabilities = availabilityConfigurations;
            return this;
        }

        public ResourceConfiguration build() {
            return new ResourceConfiguration(this.title, this.abilityConfigurations, this.availability, this.presences, this.absences, this.availabilities);
        }
    }
}

