/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.time;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.generator.GeneratorUtils;
import com.radiantminds.roadmap.common.data.generator.time.IReleaseConfiguration;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;

@Immutable
public class ReleaseConfiguration
implements IReleaseConfiguration {
    private final String title;
    private final Long startDate;
    private final Long endDate;
    private final Long delta;
    private final String primaryVersion;

    private ReleaseConfiguration(String title, Long startDate, Long endDate, Long delta, String primaryVersion) {
        this.title = title;
        this.startDate = startDate;
        this.endDate = endDate;
        this.delta = delta;
        this.primaryVersion = primaryVersion;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Optional<Long> getStartDate() {
        return Optional.fromNullable((Object)this.startDate);
    }

    @Override
    public Optional<Long> getEndDate() {
        return Optional.fromNullable((Object)this.endDate);
    }

    @Override
    public Optional<Long> getDelta() {
        return Optional.fromNullable((Object)this.delta);
    }

    @Override
    public Optional<String> getPrimaryVersion() {
        return Optional.fromNullable((Object)this.primaryVersion);
    }

    public static class Builder {
        private final String title;
        private Long startDate = null;
        private Long endDate = null;
        private Long delta = null;
        private String primaryVersion = null;

        public Builder(String title) {
            this.title = title;
        }

        public Builder withStartDate(String startDate) {
            this.startDate = GeneratorUtils.parseDate(startDate);
            return this;
        }

        public Builder withStartDate(DateTime startDate) {
            this.startDate = startDate.withZone(DateTimeZone.UTC).getMillis();
            return this;
        }

        public Builder withEndDate(String endDate) {
            this.endDate = GeneratorUtils.parseDate(endDate);
            return this;
        }

        public Builder withEndDate(DateTime endDate) {
            this.endDate = endDate.withZone(DateTimeZone.UTC).getMillis();
            return this;
        }

        public Builder withStartGap(Duration gap) {
            this.delta = gap.getMillis();
            return this;
        }

        public Builder withPrimaryVersion(String primaryVersion) {
            this.primaryVersion = primaryVersion;
            return this;
        }

        public ReleaseConfiguration build() {
            return new ReleaseConfiguration(this.title, this.startDate, this.endDate, this.delta, this.primaryVersion);
        }
    }
}

